package com.bizunited.platform.kuiper.starter.repository;

import com.bizunited.platform.kuiper.entity.PageFlowEntity;
import com.bizunited.platform.kuiper.starter.repository.internal.PageFlowRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Description: 页面流的持久化服务
 * @Author: TanBoQiuYun
 * @Date: 2019/12/31 15:40
 */
@Repository("PageFlowRepository")
public interface PageFlowRepository extends
        JpaRepository<PageFlowEntity, String>
        , JpaSpecificationExecutor<PageFlowEntity>
        , PageFlowRepositoryCustom {


  /**
   * 统计页面流名称的数量
   * @param name
   * @return
   */
  @Query("select count(*) from PageFlowEntity pf where pf.name = :name and pf.projectName = :projectName")
  long countByNameAndProjectName(@Param("name") String name, @Param("projectName") String projectName);

  /**
   * 统计页面流编码的数量
   * @param code
   * @return
   */
  @Query("select count(*) from PageFlowEntity pf where pf.code = :code ")
  long countByCode(@Param("code") String code);

  /**
   * 统计页面流名称的数量,并排除ID
   * @param name
   * @param id
   * @return
   */
  @Query("select count(*) from PageFlowEntity pf where pf.name = :name and pf.id <> :id and pf.projectName = :projectName")
  long countByNameWithoutIdAndProjectName(@Param("name") String name, @Param("id") String id, @Param("projectName") String projectName);

  /**
   * 统计页面流编码的数量,并排除ID
   * @param code
   * @param id
   * @return
   */
  @Query("select count(*) from PageFlowEntity pf where pf.code = :code and pf.id <> :id ")
  long countByCodeWithoutId(@Param("code") String code, @Param("id") String id);

  /**
   * 根据页面流ID查询流程模版明细
   * @param id
   * @return
   */
  @Query("select pf from PageFlowEntity pf left join fetch pf.pages where pf.id = :id")
  PageFlowEntity findDetailsById(@Param("id") String id);

  /**
   * 根据编码查询页面流信息
   * @param code
   * @return
   */
  @Query("from PageFlowEntity pf where pf.code = :code ")
  PageFlowEntity findByCode(@Param("code") String code);

  /**
   * 按照数页面流编码进行查询明细查询，查询的明细包含页面流下的所有关联信息
   * @param code
   * @return
   */
  @Query("select pf from PageFlowEntity pf left join fetch pf.pages where pf.code = :code ")
  PageFlowEntity findDetailsByCode(@Param("code") String code);

  /**
   * 根据ID集合统计数据
   * @param ids
   * @return
   */
  @Query("select count(*) from PageFlowEntity pf where pf.id in :ids")
  long countByIds(@Param("ids") String[] ids);

  /**
   * 根据ID集合查询详情
   * @param ids
   * @return
   */
  @Query("select pf from PageFlowEntity pf " +
      " left join fetch pf.pages pfp " +
      " left join fetch pfp.events " +
      " where pf.id in :ids")
  List<PageFlowEntity> findDetailsByids(@Param("ids") String[] ids);
}
