package com.bizunited.platform.kuiper.starter.repository;

import com.bizunited.platform.kuiper.entity.PageEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * 页面流页面数据的持久化服务
 * @Author: TanBoQiuYun
 * @Date: 2019/12/31 17:34
 */
@Repository("PageRepository")
public interface PageRepository extends JpaRepository<PageEntity, String>,
        JpaSpecificationExecutor<PageEntity> {

  /**
   * 根据页面流的ID查询页面列表
   * @param pageFlowId
   * @return
   */
  @Query("select p from PageEntity p inner join fetch p.pageFlow pf left join fetch p.events where pf.id = :pageFlowId ")
  Set<PageEntity> findDetailsByPageFlowId(@Param("pageFlowId") String pageFlowId);


  /**
   * 根据页面流code和页面code查询详情
   * @param code
   * @param pageFlowCode
   * @return
   */
  @Query("from PageEntity p inner join fetch p.pageFlow pf left join fetch p.events where p.code = :code and pf.code = :pageFlowCode ")
  PageEntity findDetailsByCodeAndPageFlowCode(@Param("code") String code, @Param("pageFlowCode") String pageFlowCode);

  /**
   * 按照页面流编码进查询页面列表详情
   * @param pageFlowCode
   * @return
   */
  @Query("select p from PageEntity p inner join fetch p.pageFlow pf left join fetch p.events where pf.code = :pageFlowCode ")
  Set<PageEntity> findDetailsByPageFlowCode(@Param("pageFlowCode") String pageFlowCode);

  /**
   * 根据页面ID查询详情
   * @param id
   * @return
   */
  @Query("from PageEntity p inner join fetch p.pageFlow pf left join fetch p.events where p.id = :id")
  PageEntity findDetailsById(@Param("id") String id);

  /**
   * 按照数页面流编码进行查询，查询的明细不包含关联信息
   * @param pageFlowCode
   * @return
   */
  @Query("select p from PageEntity p inner join p.pageFlow pf  where pf.code = :pageFlowCode ")
  Set<PageEntity> findByPageFlowCode(@Param("pageFlowCode") String pageFlowCode);

  /**
   * 根据页面流ID删除页面
   * @param pageFlowId
   */
  @Modifying
  @Query(value = "delete from engine_form_page where page_flow_id = :pageFlowId ", nativeQuery = true)
  void deleteByPageFlowId(@Param("pageFlowId") String pageFlowId);
}
