package com.bizunited.platform.kuiper.starter.repository;

import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.kuiper.entity.TemplateItemEntity;

@Repository
public interface TemplateItemRepository
    extends
      JpaRepository<TemplateItemEntity, String>,
      JpaSpecificationExecutor<TemplateItemEntity> {
  /**
   * 按照明细编辑信息所属的上级模板，其下的一般属性、关联属性
   * @param templateId
   * @return
   */
  @Query(value=" select distinct items from TemplateItemEntity items "
      + " left join fetch items.properties p "
      + " left join fetch items.relations r "
      + " where items.parentTemplate.id = :templateId ")
  public Set<TemplateItemEntity> findDetailsByParentTemplate(@Param("templateId") String templateId);

  /**
   * 按照明细编辑信息所属的上级模板，其下的一般属性、关联属性
   * @param templateIds
   * @return
   */
  @Query(value=" select distinct items from TemplateItemEntity items "
          + " left join fetch items.properties p "
          + " left join fetch items.relations r "
          + " where items.parentTemplate.id in (:templateIds) ")
  public Set<TemplateItemEntity> findDetailsByParentTemplates(@Param("templateIds") Set<String> templateIds);

  @Query(value=" select distinct items from TemplateItemEntity items "
          + " left join fetch items.properties p "
          + " left join fetch items.relations r "
          + " where items.id = :templateItemId ")
  TemplateItemEntity findDetailsById(@Param("templateItemId") String templateItemId);
  
  /**
   * 按照明细编辑信息所属的上级分组，其下的一般属性、关联属性
   * @param templateId
   * @return
   */
  @Query(value=" select distinct items from TemplateItemEntity items "
      + " left join fetch items.properties p "
      + " left join fetch items.relations r "
      + " where items.parentGroup.id = :groupId ")
  public Set<TemplateItemEntity> findDetailsByParentGroup(@Param("groupId") String groupId);

  /**
   * 根据ID查询表单模板明细，包括可能的父级表单，与可能的父级分组表单
   * @param templateItemId
   * @return
   */
  @Query(value=" select distinct items from TemplateItemEntity items "
      + " left join fetch items.parentTemplate pt "
      + " left join fetch items.parentGroup pg "
      + " where items.id = :templateItemId ")
  TemplateItemEntity findParentById(@Param("templateItemId") String templateItemId);
}
