package com.bizunited.platform.kuiper.starter.repository;

import java.util.Set;

import com.bizunited.platform.kuiper.entity.TemplateOprtLogEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository("TemplateOprtLogRepository")
public interface TemplateOprtLogRepository extends JpaRepository<TemplateOprtLogEntity, String>,JpaSpecificationExecutor<TemplateOprtLogEntity>{
  /**
   * 根据模板id查询当前模板的操作日志集
   * @param templateId
   * @return
   */
  @Query("from TemplateOprtLogEntity log "
      + " left join fetch log.template te "
      + " where te.id = :templateId  order by log.createTime desc")
  public Set<TemplateOprtLogEntity> findByTemplateId(@Param("templateId") String templateId);
}
