package com.bizunited.platform.kuiper.starter.repository;

import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.kuiper.entity.TemplateRelationEntity;

/**
 * @author yinwenjie
 */
@Repository("MainModelRPropertyRepository")
public interface TemplateRelationRepository
    extends
      JpaRepository<TemplateRelationEntity, String>,
      JpaSpecificationExecutor<TemplateRelationEntity> {
  /**
   * 按照当前上级明细定义，查询其下的所有关联信息（只包括MnayToMany和ManyToOne）
   * @param currentItemId
   * @return
   */
  @Query("from TemplateRelationEntity r left join fetch r.currentItem c where c.id = :currentItemId ")
  public Set<TemplateRelationEntity> findByCurrentItem(@Param("currentItemId") String currentItemId);
  
  /**
   * 按照当前上级分组定义，查询其下的所有关联信息（只包括MnayToMany和ManyToOne）
   * @param currentGroupId
   * @return
   */
  @Query("from TemplateRelationEntity r left join fetch r.currentGroup p where p.id = :currentGroupId ")
  public Set<TemplateRelationEntity> findByCurrentGroup(@Param("currentGroupId") String currentGroupId);
  
  /**
   * 按照当前上级模板定义，查询其下的所有关联信息（只包括MnayToMany和ManyToOne）
   * @param currentTemplateId
   * @return
   */
  @Query("from TemplateRelationEntity r left join fetch r.currentTemplate t where t.id = :currentTemplateId ")
  public Set<TemplateRelationEntity> findByCurrentTemplate(@Param("currentTemplateId") String currentTemplateId);
}