package com.bizunited.platform.kuiper.starter.repository.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.kuiper.entity.InstanceViewEntity;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository("InstanceViewRepositoryImpl")
public class InstanceViewRepositoryImpl implements InstanceViewRepositoryCustom {
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  @Autowired
  private PlatformContext platformContext;

  /* (non-Javadoc)
   * @see com.bizunited.platform.kuiper.starter.repository.internal.InstanceRepositoryCustom#findByConditions(org.springframework.data.domain.Pageable, java.util.Map)
   */
  @SuppressWarnings("unchecked")
  @Override
  public Page<InstanceViewEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {
    // 目前支持按照模板code、模板版本信息、实例域信息、实例项目名信息进行查询
    String hql = "from InstanceViewEntity ins where 1=1 ";
    String countSql = "select count(*) from InstanceViewEntity ins where 1=1 ";
    //筛选项目
    hql += " and ins.projectName=:projectName ";
    countSql += " and ins.projectName=:projectName ";
    // 模板code
    Object code = conditions.get(MESS_CODE);
    if(code != null) {
      hql += " AND ins.templateCode = :code ";
      countSql += " AND ins.templateCode = :code ";
    }
    // 实例ID
    Object instanceId = conditions.get(MESS_INSTANCE_ID);
    if(instanceId != null) {
      hql += " AND ins.id = :instanceId ";
      countSql += " AND ins.id = :instanceId ";
    }
    // 模板名称templateName
    Object templateName = conditions.get(MESS_TEMPLATE_NAME);
    if(templateName != null) {
      hql += " AND ins.templateName = :templateName ";
      countSql += " AND ins.templateName = :templateName ";
    }
    // 模板版本信息
    Object cversion = conditions.get(MESS_CVERSION);
    if(cversion != null) {
      hql += " AND ins.cversion = :cversion ";
      countSql += " AND ins.cversion = :cversion ";
    }
    // 实例域信息
    Object domain = conditions.get(MESS_DOMAIN);
    if(domain != null) {
      hql += " AND ins.domain = :domain ";
      countSql += " AND ins.domain = :domain ";
    }
    // 可能的创建时间起
    Object beginCreateTime = conditions.get(MESS_BEGIN_CREATETIME);
    if (beginCreateTime != null) {
      hql += " AND ins.createTime >= :beginCreateTime ";
      countSql += " AND ins.createTime >= :beginCreateTime ";
    }
    // 可能的创建时间止
    Object endCreateTime = conditions.get(MESS_END_CREATETIME);
    if (endCreateTime != null) {
      hql += " AND ins.createTime <= :endCreateTime ";
      countSql += " AND ins.createTime <= :endCreateTime ";
    }
    // 可能的用户名信息
    Object userName = conditions.get(MESS_USER_NAME);
    if (userName != null) {
      hql += " AND ins.creatorUserName = :userName ";
      countSql += " AND ins.creatorUserName = :userName ";
    }
    hql += " order by ins.createTime desc ";
    
    // 构造HQL查询 和 数量查询
    Query query = this.entityManager.createQuery(hql);
    Query countQuery = this.entityManager.createQuery(countSql);
    // 解译查询条件
    query.setParameter("projectName", platformContext.getAppName());
    countQuery.setParameter("projectName", platformContext.getAppName());
    this.buildParams(query, countQuery, conditions);
    
    // 构造返回信息和最新的分页结果
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<InstanceViewEntity> resutls = query.getResultList();
    
    // 查询总数量信息
    Long count = (Long)countQuery.getResultList().get(0);
    return new PageImpl<>(resutls,pageable,count.longValue());
  }
  
  private static final String MESS_CODE = "code";
  private static final String MESS_INSTANCE_ID = "instanceId";
  private static final String MESS_CVERSION = "cversion";
  private static final String MESS_TEMPLATE_NAME = "templateName";
  private static final String MESS_DOMAIN = "domain";
  private static final String MESS_PROJECT_NAME = "projectName";
  private static final String MESS_BEGIN_CREATETIME = "beginCreateTime";
  private static final String MESS_END_CREATETIME = "endCreateTime";
  private static final String MESS_USER_NAME = "userName";
  
  private void buildParams(Query query , Query countQuery , Map<String, Object> conditions) {
    Object code = conditions.get(MESS_CODE);
    if(code != null) {
      query.setParameter(MESS_CODE, code);
      countQuery.setParameter(MESS_CODE, code);
    }
    Object instanceId = conditions.get(MESS_INSTANCE_ID);
    if(instanceId != null) {
      query.setParameter(MESS_INSTANCE_ID, instanceId);
      countQuery.setParameter(MESS_INSTANCE_ID, instanceId);
    }
    Object cversion = conditions.get(MESS_CVERSION);
    if(cversion != null) {
      query.setParameter(MESS_CVERSION, cversion);
      countQuery.setParameter(MESS_CVERSION, cversion);
    }
    Object templateName = conditions.get(MESS_TEMPLATE_NAME);
    // 模板名称templateName
    if(templateName != null) {
      query.setParameter(MESS_TEMPLATE_NAME, templateName);
      countQuery.setParameter(MESS_TEMPLATE_NAME, templateName);
    }
    Object domain = conditions.get(MESS_DOMAIN);
    if(domain != null) {
      query.setParameter(MESS_DOMAIN, domain);
      countQuery.setParameter(MESS_DOMAIN, domain);
    }
    String projectName = (String) conditions.get(MESS_PROJECT_NAME);
    if(StringUtils.isNotBlank(projectName)) {
      query.setParameter(MESS_PROJECT_NAME, projectName);
      countQuery.setParameter(MESS_PROJECT_NAME, projectName);
    }
    Object beginCreateTime = conditions.get(MESS_BEGIN_CREATETIME);
    if(beginCreateTime != null) {
      query.setParameter(MESS_BEGIN_CREATETIME, beginCreateTime);
      countQuery.setParameter(MESS_BEGIN_CREATETIME, beginCreateTime);
    }
    Object endCreateTime = conditions.get(MESS_END_CREATETIME);
    if(endCreateTime != null) {
      query.setParameter(MESS_END_CREATETIME, endCreateTime);
      countQuery.setParameter(MESS_END_CREATETIME, endCreateTime);
    }
    Object userName = conditions.get(MESS_USER_NAME);
    if(userName != null) {
      query.setParameter(MESS_USER_NAME, userName);
      countQuery.setParameter(MESS_USER_NAME, userName);
    }
  }
}
