package com.bizunited.platform.kuiper.starter.repository.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.kuiper.entity.ListTemplateEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import static com.bizunited.platform.common.constant.Constants.PROJECT_NAME;


@Repository("ListTemplateRepositoryImpl")
public class ListTemplateRepositoryImpl implements ListTemplateRepositoryCustom, PageRepositoryImpl {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  @Autowired
  private PlatformContext platformContext;

  private static final String CVERSION = "cversion";
  private static final String MESS_MODIFY_START = "modifyStart";
  private static final String MESS_MODIFY_END = "modifyEnd";

  
  @Override
  public Page<ListTemplateEntity> findByConditions(Pageable pageable, Map<String, Object> conditions) {
    /*
     * 目前的查询条件是：表单名、业务领域、项目名
     * */
    StringBuilder hql = new StringBuilder("from ListTemplateEntity le where 1= 1  ");
    StringBuilder countHql = new StringBuilder("select count(*) from ListTemplateEntity le where 1 = 1 ");
    hql.append(" and le.projectName=:projectName ");
    countHql.append(" and le.projectName=:projectName ");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameters = new HashMap<>();

    Boolean defaultVersion = (Boolean)conditions.get("defaultVersion");
    if(defaultVersion != null) {
      condition.append(" AND le.defaultVersion = :defaultVersion");
      parameters.put("defaultVersion", defaultVersion);
    }
    parameters.put("projectName", platformContext.getAppName());
    // code条件
    Object code = conditions.get("code");
    if(code != null) {
      condition.append(" AND le.code like CONCAT('%', :code, '%')");
      parameters.put("code", code);
    }
    // 版本cversion条件
    Object cversion = conditions.get(CVERSION);
    if(cversion != null) {
      condition.append(" AND le.cversion = :cversion ");
      parameters.put("cversion", cversion);
    }
    // 中文名条件
    Object name = conditions.get("name");
    if(name != null) {
      condition.append(" AND le.name like CONCAT('%', :name, '%')");
      parameters.put("name", name);
    }
    // 修改时间范围-起
    Object modifyStart = conditions.get(MESS_MODIFY_START);
    if (modifyStart != null) {
      condition.append(" AND DATE_FORMAT ( le.modifyTime, '%Y-%m-%d' ) >= :modifyStart ");
      parameters.put("modifyStart", modifyStart);
    }
    // 修改时间范围-止
    Object modifyEnd = conditions.get(MESS_MODIFY_END);
    if (modifyEnd != null) {
      condition.append(" AND DATE_FORMAT ( le.modifyTime, '%Y-%m-%d' ) <= :modifyEnd ");
      parameters.put("modifyEnd", modifyEnd);
    }
    String projectName = (String) conditions.get(PROJECT_NAME);
    if(StringUtils.isNotBlank(projectName)) {
      condition.append(" AND le.projectName = :projectName");
      parameters.put("projectName", projectName);
    } else {
      condition.append(" AND (le.projectName = '' or le.projectName is null)");
    }
    hql.append(condition).append(" order by le.createTime desc ");
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
  }

  @Override
  @SuppressWarnings("unchecked")
  public List<ListTemplateEntity> findAllByConditions(ListTemplateEntity condition) {
    StringBuilder hql = new StringBuilder("select lt from ListTemplateEntity lt where 1=1 ");
    Map<String, Object> parameters = new HashMap<>();
    if(condition != null) {
      if(condition.getTstatus() != null) {
        hql.append(" and lt.tstatus = :tstatus");
        parameters.put("tstatus", condition.getTstatus());
      }
    }
    Query query = entityManager.createQuery(hql.toString());
    parameters.forEach((k, v) -> query.setParameter(k, v));
    return query.getResultList();
  }
}
