package com.bizunited.platform.kuiper.starter.repository.migrate;

import com.bizunited.platform.kuiper.entity.MigrateExportEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 数据项导出日志持久化接口定义
 * @Author: Paul Chan
 * @Date: 2020-05-18 15:15
 */
@Repository("kuiperMigrateExportRepository")
public interface MigrateExportRepository extends JpaRepository<MigrateExportEntity, String>, JpaSpecificationExecutor<MigrateExportEntity> {

  /**
   * 根据数据类型查询导出日志(无项目名)
   * @param dataType
   * @return
   */
  @Query("select me from com.bizunited.platform.kuiper.entity.MigrateExportEntity me where me.dataType = :dataType and (me.projectName = '' OR me.projectName IS NULL ) order by me.createTime desc")
  List<MigrateExportEntity> findByDataTypeAndBlankProjectName(@Param("dataType") Integer dataType);

  /**
   * 根据数据类型查询导出日志(有项目名)
   * @param dataType
   * @return
   */
  @Query("select me from com.bizunited.platform.kuiper.entity.MigrateExportEntity me where me.dataType = :dataType and me.projectName = :projectName order by me.createTime desc")
  List<MigrateExportEntity> findByDataTypeAndProjectName(@Param("dataType") Integer dataType, @Param("projectName") String projectName);
}
