package com.bizunited.platform.kuiper.starter.service;

import java.util.Set;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.kuiper.entity.InstanceActivityLogEntity;

/**
 * 表单实例变化日志的服务层接口定义
 * @author yinwenjie
 */
public interface InstanceActivityLogService {
  /**
   * 创建实例活动日志
   * @param instanceActivityLog
   * @return
   */
  public InstanceActivityLogEntity create(InstanceActivityLogEntity instanceActivityLog , JSONObject log);
  
  /**
   * 查询指定活动实例下的数据变化日志(详细信息)，并按照时间顺序进行返回
   * @param instanceActivityId 活动实例编号
   * @return
   */
  public Set<InstanceActivityLogEntity> findDetailsByInstanceActivity(String instanceActivityId);
  
  /**
   * 查询指定活动变化日志的详情，注意，这里只是查询数据库中存储的信息，并不包括变化日志的json结构信息
   * @param instanceActivityLogId 指定的实例活动变化日志编号
   * @return
   */
  public InstanceActivityLogEntity findDetailsById(String instanceActivityLogId);
  
  /**
   * 查询指定活动变化日志的详细内容，注意，这里查询的是变化详细内容的json信息。
   * @param instanceActivityLogId 指定的实例活动变化日志编号
   * @return
   */
  public JSONObject findContentById(String instanceActivityLogId);
  /**
   * 按照指定的实例编号，查询这个实例编号下最后一次发生的数据变化日志
   * @param instanceId 指定的实例编号
   * @return
   */
  public String findTopByInstanceId(String instanceId);
  /**
   * 按照指定的数据变更日志对表单数据进行恢复验证。</p>
   * 注意，该方法肯定会抛出异常，如果抛出的异常时运行时异常（RuntimeException异常或者子级异常）那么说明整个恢复过程确实出现了问题</p>
   * 如果该方法抛出的是非运行期异常，说明整个恢复过程是没有问题
   * @param instanceActivityLogId
   * @throws IllegalStateException 正常情况下，也会抛出该异常，以便进行验证后的事务回滚
   */
  public void validateRecoveryByInstanceActivityLogId(String instanceActivityLogId);
  /**
   * 按照指定的数据变更日志对表单数据进行恢复。注意：这个日志必须是当前表单实例最后一次变动的日志。
   * 另外，当前方法只能恢复当前日志项，并不提供数据日志依据时间线的批量恢复
   * @param instanceActivityLogId 指定的实例活动编号
   * @return 如果恢复成功，数据的回复情况将在数据库中体现出来，且恢复后的数据json情况也将被返回
   */
  public JSONObject recoveryByInstanceActivityLogId(String instanceActivityLogId);
  /**
   * 基于指定的实例活动编号，将对应的表单实例从最近的一次变化日志开始进行数据恢复。</p>
   * 注意，该方法肯定会抛出异常，如果抛出的异常时运行时异常（RuntimeException异常或者子级异常）那么说明整个恢复过程确实出现了问题</p>
   * 如果该方法抛出的是非运行期异常，说明整个恢复过程是没有问题
   * @param instanceActivityLogId
   * @throws Exception
   */
  public void validateRecoveryByInstanceActivityId(String targetInstanceActivityId) throws Exception;
  /**
   * 基于指定的实例活动编号，消除当前活动之后所有活动造成的数据变化影响，这里的特殊情况是要考虑多个活动存在交叉操作日志的情况：<p>
   * 
   * 示例一：</br>
   * InstanceActivityId：A，其下按照时间顺序有多次活动变化日志，编号分别为：A1、A2、A3、A4</br>
   * InstanceActivityId：B，其下按照时间顺序也有多次活动变化日志：编号为别为：B1、B2、B3、B4</br>
   * 如果targetInstanceActivityId = A，那么B4、B3、B2、B1、A4的数据将被依次恢复。也就是说表单数据信息将呈现A3活动变化后的状态。</p>
   * 
   * 示例二：</br>
   * InstanceActivityId：A，其下按照时间顺序有多次活动变化日志，且和InstanceActivityId：B中的活动交替变化，编号分别为：A1->A2->A3->A4</br>
   * InstanceActivityId：B，其下按照时间顺序有多次活动变化日志，且和InstanceActivityId：A中的活动交替变化，编号分别为：&nbsp;&nbsp;&nbsp; B1->B2->B3->B4</br>
   * 如果targetInstanceActivityId = B，那么B4->A4->B3->A3->B2->A2->B1 的数据将被依次恢复</p>
   * 
   * @param targetInstanceActivityId 指定的实例活动编号
   * @return 如果恢复成功，数据的回复情况将在数据库中体现出来，且恢复后的数据json情况也将被返回
   */
  public JSONObject recoveryByInstanceActivityId(String targetInstanceActivityId);
}
