package com.bizunited.platform.kuiper.starter.service;

import com.bizunited.platform.kuiper.entity.InstanceContextEntity;

import java.util.List;

/**
 * @Author: Paul Chan
 * @Date: 2019-04-19 11:37
 * @Description: 表单实例上下文服务接口
 */
public interface InstanceContextService {

  /**
   * 保存表单实例上下文明细
   * 如果保存的列表为空，则返回当前上下文的明细列表
   * 当前已有的明细的则更新value，当前不存在的则新增
   * @param instanceId
   * @param instanceContextItems
   * @return
   */
  List<InstanceContextEntity> save(String instanceId, List<InstanceContextEntity> instanceContextItems);

  /**
   * 放回表单实例的上下文明细列表
   * @param instanceId
   * @return
   */
  List<InstanceContextEntity> findByInstanceId(String instanceId);

  /**
   * 根据name查询表单实例的上下文明细
   * @param instanceId
   * @param name
   * @return
   */
  InstanceContextEntity findByInstanceIdAndName(String instanceId, String name);

  /**
   * 根据表单实例ID和上下文name删除上下文value
   * @param instanceId
   * @param name
   */
  void deleteByInstanceIdAndName(String instanceId, String name);
}
