package com.bizunited.platform.kuiper.starter.service;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.kuiper.entity.InstanceItemImportEntity;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.multipart.MultipartFile;

/**
 * InstanceItemImportService
 * @description: 明细项导入导出相关服务
 * @author: weitongyan
 * @date: 11/Apr/2019 16:55
 */

public interface InstanceItemImportService {

  InstanceItemImportEntity save(InstanceItemImportEntity instanceItemImportEntity);
  /**
   * 根据实例id 与明细相对路径，查询明细导入记录（分页）
   * @param templateItemId
   * @return
   */
  Page<InstanceItemImportEntity> queryPage(String templateItemId, Pageable pageable);
  
  /**
   * 上传导入模版
   * @param templateItemId  明细模版ID
   * @param rowNum 表头所在行数
   * @param file 模版EXCEL
   * @param sheetNum SHEET所在页码
   * @param opUser 登录账户
   * @return
   */
  JSONObject uploadExample(String templateItemId, MultipartFile file, Integer sheetNum, Integer rowNum,Principal opUser);


  /**
   * 导入明细数据
   * @param jsonObject 表名每列验证格式JSON
   * @param request
   * @param response
   * @param file 导入文件
   * @param sheetNum 读入EXCEL第N页，若无，则默认读入第1页
   * @param startRow 从第N行开始读入数据，若无，则默认为2
   * @param endRow 读至第N行数据，若无，则默认读到某一空白行
   * @param opUser 操作人
   * @param instanceId 表单实例ID
   * @param paramsJson 干预源参数
   * @return
   */
  JSONObject upload(JSONObject jsonObject, HttpServletRequest request , HttpServletResponse response , MultipartFile file,Integer sheetNum,Integer startRow,Integer endRow, Principal opUser,String instanceId,String paramsJson);

  /**
   * 导出明细数据
   * @param jsonObject
   * @param response
   */
  void downloadItems(JSONObject jsonObject,HttpServletResponse response);

    
}
