package com.bizunited.platform.kuiper.starter.service;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.kuiper.entity.TemplateLayoutEntity;
import java.io.IOException;
import java.util.Set;

public interface TemplateLayoutService {
  /**
   * 根据模板编号检索表单布局信息
   * @param templateId 模板编号
   * @param layoutType 布局类型：1.PC端；2.mobile端；3.print端（可以不传入，如果不传入则默认查询定义的PC端样式）
   * @param layout 表单布局
   * @return
   */
  public TemplateLayoutEntity save(String templateId , Integer layoutType , Object layout) throws IOException;
  /**
   * 按照指定的模板编号，删除其布局信息（只删除数据库就行了，文件也会移除）
   * @param templateId 指定的模板编号信息
   * @param layoutType 布局类型：1.PC端；2.mobile端；3.print端（可以不传入，如果不传入则默认查询定义的PC端样式）
   */
  public void deleteByTemplateId(String templateId , Integer layoutType);
  /**
   * 按照指定的模板编号，删除其所有布局信息（只删除数据库就行了，文件也会移除）
   * @param templateId 指定的模板编号信息
   */
  public void deleteByTemplateId(String templateId);
  /**
   * 查询指定模板id的基本布局信息（可能有多个），并不包括布局内容
   * @param templateId 模板编号
   * @return 
   */
  public Set<TemplateLayoutEntity> findByTemplateId(String templateId);
  /**
   * 查询指定模板下，指定布局类型的基本信息，并不包括布局内容
   * @param templateId 模板编号
   * @param layoutType 布局类型：1.PC端；2.mobile端；3.print端（可以不传入，如果不传入则默认查询定义的PC端样式）
   * @return
   */
  public TemplateLayoutEntity findByTemplateId(String templateId , Integer layoutType);
  /**
   * 根据模板编号查询模板信息
   * @param templateId 模板编号
   * @param layoutType 布局类型：1.PC端；2.mobile端；3.print端 （可以不传入，如果不传入则默认查询定义的PC端样式）
   * @return 
   */
  public JSONObject findDetailsByTemplateId(String templateId , Integer layoutType);
}
