package com.bizunited.platform.kuiper.starter.service.init;

import com.bizunited.platform.common.enums.ImportExecuteModeEnum;
import com.bizunited.platform.common.enums.MigrateDataTypeEnum;
import com.bizunited.platform.common.service.init.InitProcessService;
import com.bizunited.platform.common.util.FileUtils;
import com.bizunited.platform.kuiper.entity.MigrateImportEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.common.enums.FormTemplateImportEnum;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

import static com.bizunited.platform.common.constant.Constants.DEFAULT_ADMIN_ACCOUNT;

/**
 * 表单模板导入模板
 * @Author: chenrong
 * @Date: 2020/11/4 14:54
 */
@Component("FormTemplateInitProcess")
public class FormTemplateInitProcess implements InitProcessService {

  private static final Logger LOGGER = LoggerFactory.getLogger(FormTemplateInitProcess.class);
  private static final String INIT_FILE_PATH = ResourceLoader.CLASSPATH_URL_PREFIX.concat("templates/form/");
  @Autowired
  private ApplicationContext applicationContext;
  @Autowired
  private com.bizunited.platform.kuiper.starter.service.migrate.MigrateImportService templateImportService;
  @Autowired
  private TemplateService templateService;

  @Override
  public boolean doProcess() {
    return true;
  }

  @Override
  public void init() {
    SecurityUtils.setPrincipal(DEFAULT_ADMIN_ACCOUNT);
    FormTemplateImportEnum[] enums = FormTemplateImportEnum.values();
    if(enums == null ) {
      return;
    }
    for(FormTemplateImportEnum e : enums) {
      this.init(e);
    }
  }

  /**
   * 根据枚举初始化表单模板
   * @param en
   */
  private void init(FormTemplateImportEnum en) {
    if(en == null) {
      return;
    }
    List<TemplateEntity> templateEntities = this.templateService.findByCode(en.getCode());
    // 如果已存在该模板，怎不再初始化
    if(!CollectionUtils.isEmpty(templateEntities)) {
      return;
    }
    Resource resource = applicationContext.getResource(INIT_FILE_PATH.concat(en.getFileName()));
    try (InputStream inputStream = resource.getInputStream()) {
      MultipartFile multipartFile = FileUtils.transferMultipartFile(inputStream, en.getFileName());
      MigrateImportEntity migrateImportEntity = templateImportService.upload(multipartFile, MigrateDataTypeEnum.FORM_TEMPLATE.getType());
      if(migrateImportEntity == null) {
        return;
      }
      templateImportService.execute(migrateImportEntity.getId(), ImportExecuteModeEnum.ADD.getMode());
    } catch (IOException e) {
      LOGGER.error(e.getMessage(), e);
    }
  }
}
