package com.bizunited.platform.kuiper.starter.service.instances.handle;

import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;
import com.bizunited.platform.kuiper.service.DynamicInstanceService;

/**
 * 该处理器在动态表单实例发生“写”性质的操作后，进行指定表单实例详细情况的查询和记录。
 * @author yinwenjie
 */
@Component("DynamicFormDetailsResponseHandle")
public class DynamicFormDetailsResponseHandle extends AbstractDynamicFormDetailsHandle implements InvokeResponseHandle {
  private static final Logger LOGGER = LoggerFactory.getLogger(DynamicFormDetailsResponseHandle.class);
  /**
   * 用于存储后置处理得到的查询结果值的key
   */
  private static final String AFTER_DETAILS = "_afterDetails";
  /**
   * 动态实例服务
   */
  @Autowired
  private DynamicInstanceService dynamicInstanceService;
  
  @Override
  public boolean handleException(InvokeProxyContext context) {
    return false;
  }
  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
    InvokeParams invokeParams = context.getParams();
    
    /*
     * -处理过程为：
     * 1、首先从当前调用上下文中取出表单实例编号和表单实例活动编号，如果没有就报错
     * 2、调用dynamicInstanceService服务中的调用查询方法，并得到json信息
     * (注意这种情况下，isbefore为true的情况下，json信息是可以没有值的)
     * 3、将json信息记录到调用上下文中，以便后续使用
     * */
    
    // 1、=========
    String instanceId = invokeParams.getInvokeParam("instanceId").toString();
    Validate.notBlank(instanceId , "未发现指定的动态实例信息!!");
    
    // 2、=========
    JSONObject formDateJson = dynamicInstanceService.findDetailsByFormInstanceId(instanceId);
    if(formDateJson == null) {
      formDateJson = new JSONObject();
    }
    
    // 3、=========
    //后置存储json
    LOGGER.debug("后置数据：{}", formDateJson);
    invokeParams.putInvokeParam(AFTER_DETAILS, formDateJson);
    chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
  }
}