package com.bizunited.platform.kuiper.starter.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.core.controller.ServicableMethodController;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceManager;
import com.bizunited.platform.core.service.dataview.DataViewService;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.core.service.serviceable.model.ServicableMethodInfo;
import com.bizunited.platform.dictionary.common.service.dict.DictService;
import com.bizunited.platform.dictionary.common.vo.DictItemVo;
import com.bizunited.platform.dictionary.common.vo.DictVo;
import com.bizunited.platform.kuiper.entity.InstanceItemImportEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateGroupEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemExcelEntity;
import com.bizunited.platform.kuiper.entity.TemplateRelationEntity;
import com.bizunited.platform.kuiper.starter.common.excel.ExcelImportVo;
import com.bizunited.platform.kuiper.starter.repository.InstanceItemImportRepository;
import com.bizunited.platform.kuiper.starter.repository.table.TableOperateRepositoryCustom;
import com.bizunited.platform.kuiper.starter.service.InstanceItemImportService;
import com.bizunited.platform.kuiper.starter.service.TemplateGroupService;
import com.bizunited.platform.kuiper.starter.service.TemplateItemExcelService;
import com.bizunited.platform.kuiper.starter.service.TemplateItemService;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.venus.common.service.image.FileUpdateService;
import com.bizunited.platform.venus.common.vo.OrdinaryFileVo;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.security.Principal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

/**
 * InstanceItemImportServiceImpl
 * TODO 还未进行修正
 * @description:
 * @author: weitongyan
 * @date: 11/Apr/2019 16:58 TODO 代码未code review
 */
@Service("InstanceItemImportServiceImpl")
public class InstanceItemImportServiceImpl implements InstanceItemImportService {

  @Autowired private InstanceItemImportRepository instanceItemImportRepository;
  @Autowired private TemplateItemService templateItemService;
  @Autowired private TemplateGroupService templateGroupService;
  @Autowired private DictService dictService;
  @Autowired private TableOperateRepositoryCustom tableOperateRepositoryCustom;
  @Autowired private DataViewService dataViewService;
  @Autowired private DynamicDataSourceManager dynamicDataSourceManager;
  @Autowired private FileUpdateService fileUpdateService;
  @Autowired private TemplateItemExcelService templateItemExcelService;
  @Autowired private ServicableMethodService servicableMethodService;
  @Autowired private InstanceItemImportService instanceItemImportService;
  @Autowired private UserService userService;
  @Autowired private ApplicationContext applicationContext;
  @Autowired private PlatformContext platformContext;

  /**
   * 表单明细EXCEL导入导出整体逻辑整理：
   *
   * <p>===配置： 前端页面配置明细-点击使用EXCEL导入，将出现相关按钮
   * 点击上传模板，后端读入EXCEL行头信息返还前端（包括行头信息，与文件保存相对路径与文件名），此步骤将在后端保存匹配关系 TemplateItemExcelEntity
   * 前端页面上针对明细字段，选择匹配对应的EXCEL行头信息，点击保存后，将会把所有前端配置信息（字段相关匹配信息，数据源字典本地数据信，配置的后端干预服务源等），存入JSON，放在布局文件中
   *
   * <p>===下载模板： 根据JSON中的文件保存相对路径，直接调用文件系统根据路径与文件名下载
   *
   * <p>===导入： 用户上传EXCEL文件，前端将【文件，布局中的JSON，新读取的templateItemEntity的Id】等传到后端
   * 注意：此处读取数据，只涉及JSON与用户新上传的EXCEL，与之前上传的EXCEL模板无关系！
   * 读入EXCEL中每一行数据，根据JSON中的设置做初步验证（数据类型，字典，本地数据，远程调用源等），如果有错误，记录错误信息 如果初步验证通过，则根据templateItemId 查出
   * tempalateItemEntity,获取其中的 PropertyClassName，反射成为Object 循环读取，获得 List-Object 与错误信息
   * 如果设置有干预服务源，则将List-Object传入干预服务源，获取返回的List-Object，与错误信息 如果全局有错误信息，将错误信息写入用户上传的EXCEL当中，自动下载。
   * 如果没有错误信息，则保存用户上传的EXCEL记录，并将 List-Object，读取数据数量等信息，以JSON格式返回前端 至此导入流程结束，后续实例数据的修改，录入等，与导入无关。
   */

  // EXCEL导出模版默认设置行数
  private static final Integer EXCEL_MAX_ROW = 20;

  private static final List<String> DATA_TYPES =
      Arrays.asList("normal", "view", "service", "local", "dict", "iframe");

  private static final List<String> NUMBERIC =
      Arrays.asList(
            "java.math.BigDecimal",
            "java.lang.Integer",
            "java.lang.Long",
            "java.lang.Double",
            "java.lang.Short",
            "java.lang.Float",
            "java.lang.Byte"
          );

  /*
   以下部分为和前端交互JSON中商定字段
  */
  private static final String INDEX = "index";
  private static final String EXCEL_INDEX = "excelIndex";
  private static final String LIST = "list";
  private static final String FILE_PATH = "filePath";
  private static final String FILE_NAME = "fileName";
  private static final String TEMPLATE_ITEM_ID = "templateItemId";
  private static final String IS_PREVIEW = "isPreview";
  private static final String DATE_TYPE = "datatype";
  private static final String PROPERTIES = "properties";
  private static final String PROPERTY_DB_NAME = "propertyDbName";
  private static final String PROPERTY_DESC = "propertyDesc";
  private static final String PROPERTY_CLASS_NAME = "propertyClassName";
  private static final String NULLABLE = "nullable";
  private static final String PARAMS = "params";
  private static final String PROPERTY_NAME = "propertyName";
  private static final String DICT = "dict";
  private static final String NORMAL = "normal";
  private static final String SERVICE = "service";
  private static final String LOCAL = "local";
  private static final String VIEW = "view";
  private static final String IS_MANY = "isMany";
  private static final String DICT_CODE = "dictCode";
  private static final String DATA_VIEW_CODE = "dataViewCode";
  private static final String PARRENT_ID = "parrentId";
  private static final String STATIC = "static";
  private static final String DYNAMIC = "dynamic";
  private static final String KEYS = "keys";
  private static final String VALUES = "values";
  private static final String NAME = "name";
  private static final String VALUE = "value";
  private static final String DATA_SOURCE_CODE = "dataSourceCode";
  private static final String METHOD_NAME = "methodName";
  private static final String CONTENT = "content";
  private static final String IMPORT_NUM = "importNum";
  private static final String HAS_ERROR = "hasError";

  /**
   * 接口JOSN格式规定：
   *
   * <p>{ templateItemId : “”, //表单模版明细id parrentId : “xxx”, // 该明细父级实例id ， 下载明细时需要 isPreview : true
   * //是否为预览操作 methodName : "xxxx", //调用方法源名称 properties : [ { propertyName: “AAA”, //当前字段名称
   * propertyDesc :”BBB”, // 当前字段中文描述 propertyDbName : “a_a_a” //当前字段在数据库字段名 propertyClassName
   * ：//字段属性 index : 1, //行排列 nullable : false //当前属性是否可为空 datatype: ‘view’, // 指定当前控件对应的数据类型
   * normal: { } // 数据视图 view: { dataViewId : “xxx” //数据视图id dataSourceCode : “xx” // 数据源编码 param:
   * ‘’, [{name:a, value:b},{name:c,value:d}]//对应数据视图的请求参数，JSON格式 keys: ‘’, //展示参数 values: ‘’, //值参数
   * propertyName ：“” //数据视图属性 isMany: true // 多对一，多对多 }, // 数据源 service: { url: ‘’,
   * //数据源的请求地址,param: ‘’, [{name:a, value:b},{name:c,value:d}]//对应数据源的请求参数，JSON格式
   *
   * <p>}, // 本地数据 local: { keys: “aaaa,bbbb,cccc”, // 当前列的参数, values: “11111,22222,33333” // 当前参数值
   * 字符串格式，逗号相隔 }, // 对应枚举数据 dict: { dictCode: ‘’ // 对应枚举数据的code参数 } } ] }
   */
  @Override
  @Transactional
  public InstanceItemImportEntity save(InstanceItemImportEntity itemImport) {
    Validate.notNull(itemImport, "明细导入记录不能为空");
    Validate.notBlank(itemImport.getTemplateItemId(), "导入明细模版ID不能为空");
    Validate.notNull(itemImport.getOperator(), "导入明细操作者不能为空");
    itemImport.setImportDate(new Date());
    itemImport.setProjectName(platformContext.getAppName());
    return instanceItemImportRepository.save(itemImport);
  }

  @Override
  public Page<InstanceItemImportEntity> queryPage(String templateItemId, Pageable pageable) {
    Map<String, Object> conditions = new HashMap<>();
    Validate.notBlank(templateItemId, "查询参数明细模版ID不能为空！");
    conditions.put(TEMPLATE_ITEM_ID, templateItemId);
    if (pageable == null) {
      pageable = PageRequest.of(0, 50);
    }

    return instanceItemImportRepository.queryPage(pageable, conditions);
  }

  /**
   * 返回格式：{ "fieldId":"", "fileName":"", "filePath":"", "list":[ "1":"第一列名称", "2":"xxxx",
   * "3":"xxxx", ... ] }
   *
   * @param templateItemId 明细模版ID
   * @param file 模版EXCEL
   * @param sheetNum SHEET所在页码
   * @param rowNum 表头所在行数
   * @param opUser 登录账户
   * @return
   */
  @Override
  public JSONObject uploadExample(
      String templateItemId,
      MultipartFile file,
      Integer sheetNum,
      Integer rowNum,
      Principal opUser) {
    // 验证参数
    Validate.notBlank(templateItemId, "明细模版ID不能为空！");
    TemplateItemEntity templateItem = templateItemService.findDetailsById(templateItemId);
    Validate.notNull(templateItem, "明细模版ID不能为空!");
    Validate.notNull(rowNum, "设定行首排数不能为空！");
    Validate.notNull(file, "上传文件不能为空！");
    Validate.notNull(opUser, "操作者不能为空！");
    sheetNum = sheetNum == null ? 0 : sheetNum - 1;
    rowNum = rowNum == null ? 0 : rowNum - 1;
    // 解析EXCEL，获取行首信息
    JSONObject result = new JSONObject();
    JSONArray colArray = this.getExcelHead(file, sheetNum, rowNum);
    result.put(LIST, colArray);
    // 保存文件
    List<OrdinaryFileVo> ordinaryFiles =
        fileUpdateService.fileUpload(
            "excelTemplate", opUser.getName(), null, new MultipartFile[] {file});
    Validate.notEmpty(ordinaryFiles, "保存文件操作失败！");
    OrdinaryFileVo ordinaryFile = ordinaryFiles.get(0);
    result.put(FILE_NAME, ordinaryFile.getFileName());
    result.put(FILE_PATH, ordinaryFile.getRelativeLocal());
    // 保存上传EXCEL模板与表单明细模板的关联关系
    TemplateItemExcelEntity excelEntity = new TemplateItemExcelEntity();
    // 设置文件名，相对路径，原来文件名, 上传人账号,上传时间
    excelEntity.setFileName(ordinaryFile.getFileName());
    excelEntity.setOriginalFileName(ordinaryFile.getOriginalFileName());
    excelEntity.setFilePath(ordinaryFile.getRelativeLocal());
    excelEntity.setCreateDate(new Date());
    // 设置明细模板ID，父级模板ID，父级分组模板ID
    excelEntity.setTemplateItemId(templateItemId);
    TemplateItemEntity parentItemEntity = this.templateItemService.findParentById(templateItemId);
    Validate.notNull(parentItemEntity, "未根据ID查询到明细模板信息，请检查！");
    Validate.isTrue(
        parentItemEntity.getParentGroup() != null || parentItemEntity.getParentTemplate() != null,
        "未查询到该模板的父级模板或父级分组模板！");
    excelEntity.setItemPropertyName(templateItem.getPropertyName());
    // 该明细在模板下
    if (templateItem.getParentTemplate() != null) {
      excelEntity.setTemplateId(templateItem.getParentTemplate().getId());
    } else {
      // 该明细模板在分组下
      String groupId = templateItem.getParentGroup().getId();
      excelEntity.setTemplateGroupId(groupId);
      TemplateGroupEntity parentGroup = this.templateGroupService.findParentById(groupId);
      Validate.notNull(parentGroup, "未找到该模板的父级分组表单信息！");
      excelEntity.setGroupPropertyName(parentGroup.getPropertyName());
      TemplateEntity parent = parentGroup.getParentTemplate();
      Validate.notNull(parent, "未找到模板父级分组表单的关联主表单信息！");
      excelEntity.setTemplateId(parent.getId());
    }
    this.templateItemExcelService.save(excelEntity);
    return result;
  }

  /**
   * @param jsonObject 表名每列验证格式JSON
   * @param request
   * @param response
   * @param file 导入文件
   * @param sheetNum 读入EXCEL第N页，若无，则默认读入第1页
   * @param startRow 从第N行开始读入数据，若无，则默认为2
   * @param endRow 读至第N行数据，若无，则默认读到某一空白行
   * @param opUser 操作人
   * @param instanceId 表单实例ID
   * @param paramsJson 干预源参数
   * @return
   */
  @Override
  public JSONObject upload(JSONObject jsonObject,HttpServletRequest request,HttpServletResponse response,MultipartFile file,
      Integer sheetNum,Integer startRow,Integer endRow,Principal opUser,String instanceId,String paramsJson) {
    /*
     * 修改后上传明细逻辑：
     * 1.验证上传明细格式JSON是否正确,是否预览
     * 2.验证是否为预览操作，预览不进行保存上传记录
     * 3.解析上传文件，转为EXCEL格式，并验证
     * 4.解析上传格式JSON文件，获取需要读取的字段值,,并查询明细实体相关信息
     * 5. 循环读取EXCEL每一行值，直到最后一行，将读出的每一行数据反射成 Entity，并存入List
     * 6.如果该明细设定有服务源，则先将 实体数组 传入 服务源， 获取返还的实体数组
     * 7.根据JSON模板所设定数据限制，进行验证，如果有误，则将错误信息添加到行末，输出EXCEL
     *   a.读取每一条entity内容，根据JSON模版所匹配数据类型作出判断
     *     I.一般属性：验证是字符串还是数字，输入值是否符合数据类型
     *     II.数据视图：根据数据视图SQL加入用户输入属性与值，拼接查询语句，根据输入视图编码，确认为本地数据源，第三方数据源，判断是否为manyToMany关系，如果是，遍历判断，验证用户输入值是否存在
     *     III.字典：根据字典编码得到该字典所有键值对，验证用户输入值是否匹配
     *     IV.方法源：现该需求不明确，仅仅返回输入值，由前端反查验证
     *     V.本地数据：从JSON格式中获取键值对，验证输入值是否匹配 VI.如果以上有输入值验证不通过，则将错误信息添加在行末，输出EXCEL
     * 8.如果所有数据读取完毕，且无错误，则保存文件，记录上传记录 9.返回所有读入值，以JSON格式返还前端
     */
//    return null;
    // 构造整体的返回结果
    JSONObject allResult = new JSONObject();
    // 1===验证上传明细格式JSON是否正确,是否预览
    this.validateJson(jsonObject);

    // 2===验证是否为预览操作，预览不进行保存上传记录,并查询明细实体相关信息
    Boolean isPreview = jsonObject.getBoolean(IS_PREVIEW);
    Boolean hasError = false;

    // 3===解析上传文件，转为EXCEL格式，并验证
    // 因系统内起始值都为0，统一处理传入的值
    sheetNum = sheetNum == null ? 0 : sheetNum - 1;
    startRow = startRow == null ? 1 : startRow - 1;
    endRow = null;
    Workbook wb = this.readExcel(file);
    // 验证EXCEL
    Validate.notNull(wb, "解析EXCEL文件为空！");
    Sheet sheet = wb.getSheetAt(sheetNum);
    Validate.notNull(sheet, String.format("解析EXCEL第%s页 SHEET为空！", sheetNum + 1));

    // 4===解析上传格式JSON文件，获取需要读取的字段值,并查询明细实体相关信息
    List<JSONObject> propertySort = this.getSortProperties(jsonObject, PROPERTIES, INDEX);
    String itemId = jsonObject.getString(TEMPLATE_ITEM_ID);
    TemplateItemEntity item = templateItemService.findDetailsById(itemId);
    Validate.notNull(item, "未查询根据表单明细ID查询到明细信息！");
    String itemClassName = item.getPropertyClassName();
    Validate.notBlank(itemClassName, "未获取到明细实体类名信息！");
    Class<?> itemClass;
    try {
      itemClass = Class.forName(itemClassName);
    } catch (ClassNotFoundException e) {
      throw new IllegalArgumentException("未查询到该明细实体,或实体反射错误！错误信息：" + e.getMessage());
    }

    // 5=== 循环读取EXCEL每一行值，直到最后一行，将读出的每一行数据反射成 Entity，并存入List
    // 用于存储每一行的错误信息
    Map<Integer, String> errorMaps = new HashMap<>();
    List<Object> itemObjects = new ArrayList<>();
    List<Integer> filterObjectIndex = new ArrayList<>();
    Map<String, Object> returnParams;
    returnParams =
        this.readObjectFromExcel(
            itemObjects,
            sheet,
            itemClass,
            propertySort,
            startRow,
            endRow,
            errorMaps,
            hasError,
            filterObjectIndex);
    hasError = (Boolean) returnParams.get("hasError");
    Integer readEndNum = (Integer) returnParams.get("endNum");
    String totalError = "";

    // 6=== 如果该明细设定有服务源，则先将 实体数组 传入 服务源， 获取返还的实体数组
    String methodName = jsonObject.getString(METHOD_NAME);
    // 必须设定了服务源，且至少有一条数据通过了初步验证，再传入服务源中！
    if (StringUtils.isNotBlank(methodName) && !CollectionUtils.isEmpty(itemObjects)) {
      ServicableMethodInfo servicableMethod = this.servicableMethodService.findDetailsByName(methodName);
      if (null != servicableMethod) {
        // 构建执行参数
        InvokeParams invokeParams = new InvokeParams();
        // 服务名
        invokeParams.putInvokeParam("serviceName", methodName);
        // 构造 InputParamsModel 中的 customData （开发者自定义的参数），将数据存入其中
        Map<String, Object> objectMap = new HashMap<>();
        invokeParams.putInvokeParam("objects", itemObjects);
        objectMap.put("indexes", filterObjectIndex);
        // 如果实例ID存在，则传值干预源处理
        if (StringUtils.isNotBlank(instanceId)) {
          objectMap.put("instanceId", instanceId);
        }
        // 如果干预源参数存在，则传入干预源参数处理
        if (StringUtils.isNotBlank(paramsJson)) {
          objectMap.put("paramsJson", paramsJson);
        }
        invokeParams.putInvokeParams(objectMap);
        // 执行设定的服务源，获取结果
        ServicableMethodController controller = (ServicableMethodController) applicationContext.getBean("StaticFormProxyController");
        Object result = controller.invoke(request,methodName, null,null,invokeParams);
        Validate.notNull(result, "EXCEL导入执行设定服务源后，返回数据不能为空！");

        ExcelImportVo importVo = (ExcelImportVo) result;

        itemObjects = importVo.getObjects();
        List<String> errors = importVo.getErrorMsgs();
        List<Integer> errorIndexes = importVo.getErrorIndexs();
        totalError = importVo.getTotalError();
        errorMaps = this.addSeviceMethodError(errorMaps, errors, errorIndexes);
        // 如果数据源返回有错误，同样要输出错误EXCEL
        if (!CollectionUtils.isEmpty(errors) || StringUtils.isNotBlank(totalError)) {
          hasError = true;
        }
      }
    }
    // 将数据写入整体的返回体中
    allResult.put(CONTENT, itemObjects);
    allResult.put(IMPORT_NUM, itemObjects.size());

    // 7===如果有误，则将错误信息添加到行末，输出EXCEL
    if (Boolean.TRUE.equals(hasError)) {
      allResult.put(HAS_ERROR, true);
      // 获取表头的行数
      Integer headRowNum = startRow - 1 < 0 ? 0 : startRow - 1;
      // 获取填充错误信息的列数
      Integer errorCol = this.getErrorCol(sheet, headRowNum);
      wb = this.addErrorMsg(wb, sheetNum, errorMaps, errorCol, totalError, readEndNum);
      this.exportExcel(response, wb, item.getPropertyDesc());
    }

    // 8===如果所有数据读取完毕，且无错误，则保存文件，记录上传记录
    if (!Boolean.TRUE.equals(isPreview) && !Boolean.TRUE.equals(hasError)) {
      MultipartFile[] files = {file};
      // 暂时未设定subsystem
      List<OrdinaryFileVo> saveFiles =
          fileUpdateService.fileUpload("", opUser.getName(), null, files);
      Validate.notEmpty(saveFiles, "上传文件保存失败！");
      OrdinaryFileVo ordinaryFile = saveFiles.get(0);
      // 保存导入文件，存入导入成功记录
      InstanceItemImportEntity itemImport = new InstanceItemImportEntity();
      String operator = opUser.getName();
      Validate.notBlank(operator, "上传需要传入操作者account");
      UserVo userVo = userService.findByAccount(operator);
      Validate.notNull(userVo, "未查询到用户信息！");
      itemImport.setTemplateItemId(itemId);
      // TODO: 2020-03-24 需要修改为保存用户的账户名
      itemImport.setOperator(userVo.getAccount());
      itemImport.setImportDate(new Date());
      itemImport.setImportNum(itemObjects.size());
      itemImport.setOriginalExcelName(ordinaryFile.getOriginalFileName());
      itemImport.setExcelName(ordinaryFile.getFileName());
      itemImport.setUploadPath(ordinaryFile.getRelativeLocal());
      itemImport.setOrdinaryFileId(ordinaryFile.getId());
      instanceItemImportService.save(itemImport);
      allResult.put(HAS_ERROR, false);
    }

    return allResult;
  }

  /**
   * 获取填充错误信息的列数：标题行没有的内容的第一列！
   *
   * @param sheet 表单
   * @param rowNum 读入的行数
   * @return
   */
  private Integer getErrorCol(Sheet sheet, Integer rowNum) {
    Validate.notNull(sheet, "表单不能为空！");
    Validate.notNull(rowNum, "读入信息行数不能为空");
    Validate.isTrue(rowNum >= 0, "读入行数必须大于0");
    Integer errorCol = 0;
    Boolean hasData = true;
    Row row = sheet.getRow(rowNum);
    if (row == null) {
      return errorCol;
    }
    while (Boolean.TRUE.equals(hasData)) {
      Cell cell = row.getCell(errorCol);
      if (cell == null) {
        hasData = false;
      } else {
        String value = cell.getStringCellValue();
        if (StringUtils.isBlank(value)) {
          hasData = false;
        }
      }
      errorCol++;
    }
    return errorCol - 1;
  }

  @Override
  public void downloadItems(JSONObject jsonObject, HttpServletResponse response) {
    /*
     * 下载当前明细数据逻辑：
     * 1.验证JSON格式
     * 2.获取选定字段，并排序
     * 3.根据JSON格式构造EXCEL
     * 4.查询明细数据，动态执行SQL查询，静态调用方法源或者数据视图
     * 5.根据查询的结果，分别写入EXCEL，并返还前端
     */
    // 1===
    this.validateJson(jsonObject);
    String itemId = jsonObject.getString(TEMPLATE_ITEM_ID);
    TemplateItemEntity item = templateItemService.findDetailsById(itemId);
    // 2===
    List<JSONObject> propertySort = this.getSortProperties(jsonObject, PROPERTIES, INDEX);
    // 3===
    HSSFWorkbook workbook = this.createWorkBook(jsonObject);
    HSSFSheet sheet = workbook.getSheetAt(0);
    // 4===
    if (item.getType().equals(STATIC)) {
      workbook = this.downloadStaticItems(jsonObject);
    } else if (item.getType().equals(DYNAMIC)) {
      this.downloadDynamicItems(jsonObject, sheet, propertySort);
    }
    // 5===
    this.exportExcel(response, workbook, item.getPropertyDesc());
  }

  /**
   * 从EXCEL当中读取数据，返回实体数组
   *
   * @param itemObjects 存储转化后的实体信息，对外输出
   * @param sheet EXCEL数据表
   * @param classType 明细类信息
   * @param sortedProperties 排列后的属性json信息
   * @param startRow 开始读入的行数，默认以0起始
   * @param endRow 结束的行数，若为空，则默认读至空白行
   * @param errorMsg 保存的初步数据转化的错误
   * @param hasError 数据是否有误
   * @return 数据是否有误
   */
  private <T> Map<String, Object> readObjectFromExcel(
      List<Object> itemObjects,
      Sheet sheet,
      Class<T> classType,
      List<JSONObject> sortedProperties,
      Integer startRow,
      Integer endRow,
      Map<Integer, String> errorMsg,
      Boolean hasError,
      List<Integer> filterObjectIndex) {

    /**
     * 执行逻辑： 1.验证第一次读入的第N行，是否有数据 2.循环遍历每一行，从每行的第一列到最后一列 2a.验证是否为必填项，是否有值
     * 2b.如果为一般数据类型，判断是否为数字或字符串，并作验证 2c.如果为数据视图类型，验证数据是否存在 2d.如果为字典类型，验证并转化 2e.如果为服务源类型，不验证
     * 2f.如果为本地数据类型，验证并转化 3.将读出的本行数据，封装为此明细项实体的Object，并存入实体数组中，继续读入下一行数据
     */
    // 1===循环遍历是否读入下一行
    Boolean hasNextRow = this.hasNextRow(sheet, startRow, sortedProperties, endRow);
    // 从第N行开始读入文件写入内容,
    Integer readRowNum = startRow;
    // 2===
    while (Boolean.TRUE.equals(hasNextRow)) {
      Boolean thisRowError = false;
      Row row = sheet.getRow(readRowNum);
      // 判断是否读入下一行
      hasNextRow = this.hasNextRow(sheet, readRowNum + 1, sortedProperties, endRow);
      JSONObject itemJson = new JSONObject();
      for (JSONObject colJson : sortedProperties) {
        // 获取当列列数
        Integer excelIndex = colJson.getInteger(EXCEL_INDEX) - 1;
        String dataType = colJson.getString(DATE_TYPE);
        // 2a===验证是否必填，验证是否有值
        if (!Boolean.TRUE.equals(colJson.getBoolean(NULLABLE))) {
          String value = this.getCellValue(row.getCell(excelIndex));
          // 若此项必填，且无值，则记录错误
          if (StringUtils.isBlank(value)) {
            errorMsg.put(
                readRowNum,
                StringUtils.join(
                    errorMsg.get(readRowNum), String.format("第%s项数据为必填项，请检查！", excelIndex + 1)));
            hasError = true;
            break;
          }
        }
        // 2b===一般数据类型，先判断是否为数字，针对数字做验证，如非数字类型，则读出字符串即可
        if (StringUtils.equals(dataType, NORMAL)) {
          String propertyClassName = colJson.getString(PROPERTY_CLASS_NAME);
          // 如果值为数字类型， 则检测数字里面是否含有非数字字符
          if (NUMBERIC.contains(propertyClassName)) {
            if (row.getCell(excelIndex) != null
                && !StringUtils.isBlank(this.getCellValue(row.getCell(excelIndex)))) {
              // 判断是否为数字类型
              Boolean isNumberic =
                  this.getCellValue(row.getCell(excelIndex)).matches("-?[0-9]+.*[0-9]*");
              if (!Boolean.TRUE.equals(isNumberic)) {
                errorMsg.put(
                    readRowNum,
                    StringUtils.join(
                        errorMsg.get(readRowNum),
                        String.format("第%s项数据要求为数字，请检查！", excelIndex + 1)));
                thisRowError = true;
                break;
              }
              // 根据数字类型，分别读入
              if (StringUtils.equals(propertyClassName, "java.math.BigDecimal")) {
                String value = this.getCellValue(row.getCell(excelIndex));
                itemJson.put(colJson.getString(PROPERTY_NAME), new BigDecimal(value));
              }
              if (StringUtils.equals(propertyClassName, "java.lang.Integer")) {
                String value = this.getCellValue(row.getCell(excelIndex));
                itemJson.put(colJson.getString(PROPERTY_NAME), Integer.valueOf(value));
              }
              if (StringUtils.equals(propertyClassName, "java.lang.Long")) {
                itemJson.put(
                    colJson.getString(PROPERTY_NAME),
                    Long.valueOf(row.getCell(excelIndex).getStringCellValue()));
              }
              if (StringUtils.equals(propertyClassName, "java.lang.Double")) {
                itemJson.put(
                    colJson.getString(PROPERTY_NAME),
                    Double.valueOf(row.getCell(excelIndex).getStringCellValue()));
              }
              if (StringUtils.equals(propertyClassName, "java.lang.Short")) {
                itemJson.put(
                    colJson.getString(PROPERTY_NAME),
                    Short.valueOf(row.getCell(excelIndex).getStringCellValue()));
              }
              if (StringUtils.equals(propertyClassName, "java.lang.Float")) {
                itemJson.put(
                    colJson.getString(PROPERTY_NAME),
                    Float.valueOf(row.getCell(excelIndex).getStringCellValue()));
              }
              if (StringUtils.equals(propertyClassName, "java.lang.Byte")) {
                itemJson.put(
                    colJson.getString(PROPERTY_NAME),
                    Byte.valueOf(row.getCell(excelIndex).getStringCellValue()));
              }
            }
          } else {
            // 如果不是数字类型，读入 string 类型数据
            if (row.getCell(excelIndex) != null
                && !StringUtils.isBlank(this.getCellValue(row.getCell(excelIndex)))) {
              itemJson.put(
                  colJson.getString(PROPERTY_NAME), this.getCellValue(row.getCell(excelIndex)));
            }
          }
        }
        // 2c===数据视图类型，不验证，后续交由干预源验证
        if (StringUtils.equals(dataType, VIEW)) {
          itemJson.put(
              colJson.getString(PROPERTY_NAME), this.getCellValue(row.getCell(excelIndex)));
        }
        // 2d===字典类型，需要转换
        if (StringUtils.equals(dataType, DICT)) {
          JSONObject dictJson = colJson.getJSONObject(dataType);
          Page<DictVo> dicts =
              dictService.findByConditions(
                  dictJson.getString(DICT_CODE), null, null, null, PageRequest.of(0, 50));
          DictVo dict = dicts.getContent().get(0);
          List<String> keys =
              dict.getDictItems().stream()
                  .map(DictItemVo::getDictKey)
                  .collect(Collectors.toList());
          if (row.getCell(excelIndex) != null
              && !StringUtils.isBlank(this.getCellValue(row.getCell(excelIndex)))) {
            String readKey = this.getCellValue(row.getCell(excelIndex));
            if (keys.contains(readKey)) {
              List<DictItemVo> dictItem =
                  dict.getDictItems().stream()
                      .filter(
                          o -> o.getDictKey().equals(row.getCell(excelIndex).getStringCellValue()))
                      .collect(Collectors.toList());
              Validate.isTrue(!CollectionUtils.isEmpty(dictItem), "填入值不匹配字典中");
              itemJson.put(colJson.getString(PROPERTY_NAME), dictItem.get(0).getDictValue());
            } else {
              errorMsg.put(
                  readRowNum,
                  StringUtils.join(
                      errorMsg.get(readRowNum),
                      String.format("第%s列填入值未在设定字典里，请检查！", excelIndex + 1)));

              thisRowError = true;
              break;
            }
          }
        }
        // 2e===服务源类型，不验证，后续交由干预源验证
        if (StringUtils.equals(dataType, SERVICE)) {
          itemJson.put(
              colJson.getString(PROPERTY_NAME), this.getCellValue(row.getCell(excelIndex)));
        }
        // 2f===本地数据类型，转换数据
        if (StringUtils.equals(dataType, LOCAL)) {
          JSONObject kvJson = colJson.getJSONObject(dataType);
          String keysStr = kvJson.getString(KEYS);
          String valuesStr = kvJson.getString(VALUES);
          List<String> keys = Arrays.asList(StringUtils.split(keysStr, ","));
          List<String> values = Arrays.asList(StringUtils.split(valuesStr, ","));
          if (row.getCell(excelIndex) != null
              && !StringUtils.isBlank(this.getCellValue(row.getCell(excelIndex)))) {
            String cellValue = this.getCellValue(row.getCell(excelIndex));
            if (keys.contains(cellValue)) {
              itemJson.put(colJson.getString(PROPERTY_NAME), values.get(keys.indexOf(cellValue)));
            } else {
              errorMsg.put(
                  readRowNum,
                  StringUtils.join(
                      errorMsg.get(readRowNum),
                      String.format("第%s列填入值未在设定本地数据里，请检查！", excelIndex + 1)));
              thisRowError = true;
              break;
            }
          }
        }
      }

      // 如果本条数据无错误，则可生成实体
      if (!Boolean.TRUE.equals(thisRowError)) {
        // 3===
        String itemJsonStr = itemJson.toJSONString();
        ObjectMapper om = new ObjectMapper();
        try {
          T itemObject = om.readValue(itemJsonStr, classType);
          itemObjects.add(itemObject);
          filterObjectIndex.add(readRowNum);
        } catch (IOException e) {
          String message = e.getMessage();
          int index = message.lastIndexOf(".");
          message = message.substring(index + 1);
          throw new IllegalArgumentException("导入数据转换中发生错误！原因：是" + message + "字段类型错误，请检查！");
        }
      }

      // 如果本行有错，则设置全局有错
      if (Boolean.TRUE.equals(thisRowError)) {
        hasError = true;
      }

      readRowNum = readRowNum + 1;
    }

    Map<String, Object> returnMap = new HashMap<>();
    returnMap.put("hasError", hasError);
    returnMap.put("endNum", readRowNum);

    return returnMap;
  }

  /**
   * 将错误信息写入EXCEL中
   *
   * @param wb excel
   * @param sheetNum 表数
   * @param errorMsg 错误信息MAP
   * @param errorCol 写入的列数
   * @param totalError 位于底部的总的错误信息
   * @param readEndRow 底部的行数
   * @return
   */
  private Workbook addErrorMsg(
      Workbook wb,
      Integer sheetNum,
      Map<Integer, String> errorMsg,
      Integer errorCol,
      String totalError,
      Integer readEndRow) {
    Sheet sheet = wb.getSheetAt(sheetNum);
    Set<Integer> rowNums = errorMsg.keySet();

    // 添加红色字体：
    CellStyle red = wb.createCellStyle();
    Font font = wb.createFont();
    font.setColor((short) 10);
    red.setFont(font);

    for (Integer rowNum : rowNums) {
      Row row = sheet.getRow(rowNum);
      if (row == null) {
        row = sheet.createRow(rowNum);
      }
      Cell cell = row.getCell(errorCol);
      if (cell == null) {
        cell = row.createCell(errorCol);
      }
      cell.setCellStyle(red);
      cell.setCellValue(errorMsg.get(rowNum));
    }

    // 在最底部加入全局错误信息
    if (null != readEndRow && StringUtils.isNotBlank(totalError)) {
      Row row = sheet.getRow(readEndRow);
      if (row == null) {
        row = sheet.createRow(readEndRow);
        Cell cell = row.getCell(0);
        if (cell == null) {
          cell = row.createCell(0);
        }
        cell.setCellStyle(red);
        cell.setCellValue(totalError);
      }
    }
    return wb;
  }

  /**
   * 转化上传文件为HSSFWorkbook格式
   *
   * @param file
   * @return
   */
  private Workbook readExcel(MultipartFile file) {
    Workbook wb = null;
    try {
      InputStream in = file.getInputStream();
      // 根据文件原始名后缀，判断是 .xlsx 还是 .xls
      String fileName = file.getOriginalFilename();
      Validate.notBlank(fileName, "上传文件文件名为空，请检查！");
      if (StringUtils.endsWith(fileName, ".xlsx")) {
        wb = new XSSFWorkbook(in);
      } else if (StringUtils.endsWith(fileName, ".xls")) {
        wb = new HSSFWorkbook(in);
      } else {
        throw new IllegalArgumentException("上传文件不是Excel文件!");
      }
    } catch (IOException e) {
      throw new IllegalArgumentException("解析上传文件发生错误！错误原因：" + e.getMessage());
    }
    return wb;
  }

  /**
   * 读取EXCEL行首信息
   *
   * @param file
   * @param sheetNum 页码数
   * @param rowNum 行首信息所在行数
   * @return
   */
  private JSONArray getExcelHead(MultipartFile file, Integer sheetNum, Integer rowNum) {
    // 设置默认页码数行数
    sheetNum = sheetNum == null ? 0 : sheetNum;
    rowNum = rowNum == null ? 0 : rowNum;
    Validate.notNull(file, "上传文件不能为空！");
    // 解析EXCEL，验证页码与目标行数
    Workbook workbook = this.readExcel(file);
    Validate.notNull(workbook, "解析EXCEL文件出错！");
    Sheet sheet = workbook.getSheetAt(sheetNum);
    Validate.notNull(sheet, String.format("未在EXCEL页码%s中找到对应表单", sheetNum));
    Row row = sheet.getRow(rowNum);
    Validate.notNull(row, String.format("未在EXCEL文件第%s页中找到对应%s行信息", sheetNum + 1, rowNum + 1));
    // 读取该行信息，以 列数-内容 的形势存入 json
    JSONArray colArray = new JSONArray();
    String cellValue = "notBlank";
    Integer colNum = 0;
    while (!StringUtils.isBlank(cellValue)) {
      JSONObject item = new JSONObject();
      Cell cell = row.getCell(colNum);
      colNum = colNum + 1;
      if (cell == null || StringUtils.isBlank(this.getCellValue(cell))) {
        cellValue = "";
      } else {
        item.put(String.valueOf(colNum), this.getCellValue(cell));
        colArray.add(item);
      }
    }
    return colArray;
  }

  /**
   * 对前端传入属性串排序
   *
   * @param jsonObject
   * @param propertyName
   * @param indexName
   * @return
   */
  private List<JSONObject> getSortProperties(
      JSONObject jsonObject, String propertyName, String indexName) {
    JSONArray properties = jsonObject.getJSONArray(propertyName);
    // 验证字段index是必填项，并且根据index排序
    List<JSONObject> propertyList = properties.toJavaList(JSONObject.class);
    // 与前端商定，排除excelIddex 为-1 的项
    return
        propertyList.stream()
            .filter(
                o ->
                    null != o.getInteger(indexName)
                        && o.getInteger(EXCEL_INDEX) != null
                        && -1 != o.getInteger(EXCEL_INDEX))
            .sorted(Comparator.comparing(o -> o.getInteger(indexName)))
            .collect(Collectors.toList());
  }

  /**
   * 根据模版JSON文件生成EXCEL
   *
   * @param jsonObject
   * @return
   */
  private HSSFWorkbook createWorkBook(JSONObject jsonObject) {
    // 根据模版初始化整个表单
    String itemId = jsonObject.getString(TEMPLATE_ITEM_ID);
    TemplateItemEntity item = templateItemService.findDetailsById(itemId);
    HSSFWorkbook workbook = new HSSFWorkbook();
    HSSFSheet sheet = workbook.createSheet(item.getPropertyDesc());
    // 行数排版管理
    int sheetRowNum = 0;
    // 第一行写入基础信息
    sheet = this.writeHEAD(sheet, sheetRowNum, item);
    sheetRowNum = sheetRowNum + 1;
    // 第二行写入一般属性名称+关联属性名
    JSONArray properties = jsonObject.getJSONArray(PROPERTIES);
    // 验证字段index是必填项，并且根据index排序
    List<JSONObject> propertyList = properties.toJavaList(JSONObject.class);
    List<JSONObject> propertySort =
        propertyList.stream()
            .filter(o -> null != o.getInteger(INDEX))
            .sorted(Comparator.comparing(o -> o.getInteger(INDEX)))
            .collect(Collectors.toList());
    Integer propertySize = propertySort.size();
    // 初始化填值区域,行数为第二行至默认行，列数0至属性数量（多一行预制的错误信息列）
    sheet =
        initSheet(sheet, sheetRowNum, sheetRowNum + EXCEL_MAX_ROW + 1, 0, propertySize);
    HSSFRow secoundRow = sheet.getRow(sheetRowNum);
    // 遍历每一列，填入字段名，并格式化每一列
    for (int colNum = 0; colNum < propertySize; colNum++) {
      JSONObject colJson = propertySort.get(colNum);
      secoundRow.createCell(colNum).setCellValue(colJson.getString(PROPERTY_DESC));
      // 得到该列数据类型
      String dataType = colJson.getString(DATE_TYPE);
      // 如果该列数据类型为一般属性字段， if (dataType.equals(NORMAL)) {}

      // 如果数据类型为本地数据
      if (dataType.equals(LOCAL)) {
        JSONObject kvJson = colJson.getJSONObject(dataType);
        String keysStr = kvJson.getString(KEYS);
        // 格式化内容区
        sheet =
            setHSSFValidation(
                sheet,
                StringUtils.split(keysStr, ","),
                sheetRowNum,
                sheetRowNum + EXCEL_MAX_ROW,
                colNum,
                colNum);
      }
      // 如果数据类型为字典
      if (dataType.equals(DICT)) {
        JSONObject dictJson = colJson.getJSONObject(DICT);
        Page<DictVo> dicts =
            dictService.findByConditions(
                dictJson.getString(DICT_CODE), null, null, null, PageRequest.of(0, 50));
        DictVo dict = dicts.getContent().get(0);
        List<String> keys =
            dict.getDictItems().stream()
                .map(DictItemVo::getDictKey)
                .collect(Collectors.toList());
        // 格式化内容区
        sheet =
            setHSSFValidation(
                sheet,
                keys.stream().toArray(String[]::new),
                sheetRowNum,
                sheetRowNum + EXCEL_MAX_ROW,
                colNum,
                colNum);
      }
      // 如果数据类型为方法源 if (dataType.equals(SERVICE)) {}


      // 如果数据类型为数据视图 if (dataType.equals(VIEW)) {}

    }
    this.setAreaBorder(sheet, workbook, sheetRowNum, sheetRowNum + EXCEL_MAX_ROW, 0, propertySize - 1);
    return workbook;
  }

  /**
   * 判断是否读入下一行
   *
   * @param sheet
   * @param currentRow
   * @param propertySort
   * @param endRow
   * @return
   */
  private Boolean hasNextRow(
      Sheet sheet, Integer currentRow, List<JSONObject> propertySort, Integer endRow) {
    // 如果当前行超出 设定的最后一行，则不继续读入
    if (endRow != null && currentRow > endRow) {
      return false;
    }
    // 如果当前行没有数据，则不往下读
    Row row = sheet.getRow(currentRow);
    if (row == null) {
      return false;
    }
    // 如果当前行任何一列有值，则继续读
    for (JSONObject colJson : propertySort) {
      Cell cell = row.getCell(colJson.getInteger(EXCEL_INDEX) - 1);
      if (cell != null && StringUtils.isNotBlank(this.getCellValue(cell))) {
        return true;
      }
    }
    return false;
  }

  /**
   * 导出EXCEL到页面
   *
   * @param response
   * @param workbook
   * @param fileName
   */
  private void exportExcel(HttpServletResponse response, Workbook workbook, String fileName) {
    // 输出至网页
    try {
      response.setContentType("application/octet-stream;charset=utf-8");
      response.setHeader(
          "Content-Disposition",
          "attachment;filename=" + URLEncoder.encode(fileName + ".xls", "utf-8"));
      response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
      ServletOutputStream outputStream = response.getOutputStream();
      workbook.write(outputStream);
      // 此处必须执行关闭操作，不然前端获取contentType有误
      outputStream.flush();
      outputStream.close();
    } catch (IOException e) {
      throw new IllegalStateException(e.getMessage(), e);
    }
  }

  /**
   * 为某个区域设置下拉框
   *
   * @param sheet 表单
   * @param textlist 下拉框预选值
   * @param firstRow 起始行
   * @param endRow 终止行
   * @param firstCol 起始列
   * @param endCol 终止列
   * @return
   */
  private HSSFSheet setHSSFValidation(
      HSSFSheet sheet, String[] textlist, int firstRow, int endRow, int firstCol, int endCol) {
    // 加载下拉列表内容
    DVConstraint constraint = DVConstraint.createExplicitListConstraint(textlist);
    // 设置数据有效性加载在哪个单元格上,四个参数分别是：起始行、终止行、起始列、终止列
    CellRangeAddressList regions = new CellRangeAddressList(firstRow, endRow, firstCol, endCol);
    // 数据有效性对象
    HSSFDataValidation dataValidationList = new HSSFDataValidation(regions, constraint);
    sheet.addValidationData(dataValidationList);
    return sheet;
  }

  /**
   * 初始化表格单元格
   *
   * @param sheet
   * @param firstRow
   * @param endRow
   * @param firstCol
   * @param endCol
   * @return
   */
  private HSSFSheet initSheet(
      HSSFSheet sheet, int firstRow, int endRow, int firstCol, int endCol) {
    for (int rowNum = firstRow; rowNum <= endRow; rowNum++) {
      HSSFRow row = sheet.createRow(rowNum);
      for (int colNum = firstCol; colNum <= endCol; colNum++) {
        row.createCell(colNum);
      }
    }
    return sheet;
  }

  /**
   * 为区域添加边框
   *
   * @param sheet
   * @param workbook
   * @param firstRow
   * @param endRow
   * @param firstCol
   * @param endCol
   * @return
   */
  private HSSFSheet setAreaBorder(
      HSSFSheet sheet, HSSFWorkbook workbook, int firstRow, int endRow, int firstCol, int endCol) {
    HSSFCellStyle styleLeft = workbook.createCellStyle();
    HSSFCellStyle styleRight = workbook.createCellStyle();
    HSSFCellStyle styleTop = workbook.createCellStyle();
    HSSFCellStyle styleBottom = workbook.createCellStyle();
    styleLeft.setBorderLeft(BorderStyle.THIN);
    styleRight.setBorderRight(BorderStyle.THIN);
    styleTop.setBorderTop(BorderStyle.THIN);
    styleBottom.setBorderBottom(BorderStyle.THIN);
    HSSFCellStyle styleLeftTop = workbook.createCellStyle();
    styleLeftTop.setBorderLeft(BorderStyle.THIN);
    styleLeftTop.setBorderTop(BorderStyle.THIN);
    HSSFCellStyle styleTopRight = workbook.createCellStyle();
    styleTopRight.setBorderRight(BorderStyle.THIN);
    styleTopRight.setBorderTop(BorderStyle.THIN);
    HSSFCellStyle styleLeftButtom = workbook.createCellStyle();
    styleLeftButtom.setBorderLeft(BorderStyle.THIN);
    styleLeftButtom.setBorderBottom(BorderStyle.THIN);
    HSSFCellStyle styleButtomRight = workbook.createCellStyle();
    styleButtomRight.setBorderRight(BorderStyle.THIN);
    styleButtomRight.setBorderBottom(BorderStyle.THIN);

    for (int i = firstRow; i <= endRow; i++) {
      // 左侧边框
      HSSFCell cellLeft = sheet.getRow(i).getCell(firstCol);
      cellLeft.setCellStyle(styleLeft);
      // 右侧
      HSSFCell cellRight = sheet.getRow(i).getCell(endCol);
      cellRight.setCellStyle(styleRight);
    }
    for (int i = firstCol; i <= endCol; i++) {
      // 顶部
      HSSFCell cellTop = sheet.getRow(firstRow).getCell(i);
      cellTop.setCellStyle(styleTop);
      // 底部
      HSSFCell cellBottom = sheet.getRow(endRow).getCell(i);
      cellBottom.setCellStyle(styleBottom);
    }
    // 补全左上
    HSSFCell cellLeftTop = sheet.getRow(firstRow).getCell(firstCol);
    cellLeftTop.setCellStyle(styleLeftTop);
    // 右上
    HSSFCell cellRightTop = sheet.getRow(firstRow).getCell(endCol);
    cellRightTop.setCellStyle(styleTopRight);
    // 左下
    HSSFCell cellLeftBottom = sheet.getRow(endRow).getCell(firstCol);
    cellLeftBottom.setCellStyle(styleLeftButtom);
    // 右下
    HSSFCell cellRightBottom = sheet.getRow(endRow).getCell(endCol);
    cellRightBottom.setCellStyle(styleButtomRight);
    return sheet;
  }

  /**
   * 读入单元格值，返回String类型
   *
   * @param cell
   * @return
   */
  private String getCellValue(Cell cell) {
    if (cell == null) {
      return "";
    }
    CellType type = cell.getCellType();
    if (type == null) {
      type = CellType.STRING;
    }
    String value = "";
    if (type.equals(CellType.NUMERIC)) {
      value = String.valueOf((long) cell.getNumericCellValue());
    } else if (type.equals(CellType.STRING)) {
      value = cell.getStringCellValue();
    } else if (type.equals(CellType.BOOLEAN)) {
      value = String.valueOf(cell.getBooleanCellValue());
    }
    return value;
  }

  /** 对传入的JSON执行初步验证 */
  private void validateJson(JSONObject json) {
    // 根据模版初始化整个表单
    String itemId = json.getString(TEMPLATE_ITEM_ID);
    Validate.notBlank(itemId, "模版明细ID不能为空！");
    Boolean isPreview = json.getBoolean(IS_PREVIEW);
    Validate.notNull(isPreview, "JSON中缺失参数：isPreview，请检查！");
    TemplateItemEntity item = templateItemService.findDetailsById(itemId);
    Validate.notNull(item, "未找到该模版明细！");
    JSONArray properties = json.getJSONArray(PROPERTIES);
    Validate.isTrue(properties != null && !CollectionUtils.isEmpty(properties), "传入属性集不能为空！");
    // 验证字段index是必填项，并且根据index排序
    List<JSONObject> propertyList = properties.toJavaList(JSONObject.class);
    Validate.notEmpty(propertyList, "传入属性集转换后不能为空");
    List<JSONObject> propertySort =
        propertyList.stream()
            .filter(o -> null != o.getInteger(INDEX))
            .sorted(Comparator.comparing(o -> o.getInteger(INDEX)))
            .collect(Collectors.toList());
    Validate.notEmpty(propertySort, "传入属性集中必须填入排序值");

    for (JSONObject colJson : propertySort) {
      // 验证排序
      Integer index = colJson.getInteger(INDEX);
      Validate.notNull(index, "未获取到明细排序！");
      // 验证属性名
      String propertyName = colJson.getString(PROPERTY_NAME);
      Validate.notBlank(propertyName, String.format("第%s属性未获取到属性名", index));
            /*验证数据库字段名
            String propertyDbName = colJson.getString(PROPERTY_DB_NAME);
            Validate.notBlank(propertyDbName,String.format("第%s属性未获取到数据库字段名",index));
       验证属性类型*/
      String dataType = colJson.getString(DATE_TYPE);
      Validate.isTrue(
          StringUtils.isNotEmpty(dataType) && DATA_TYPES.contains(dataType),
          String.format("属性%s数据类型错误，请检查", colJson.get(PROPERTY_NAME)));
      // 验证是否必填
      Boolean nullable = colJson.getBoolean(NULLABLE);
      Validate.isTrue(nullable != null, String.format("第%s属性未获取到是否必填", index));

      // 如果该列数据类型为一般属性字段，
      if (dataType.equals(NORMAL)) {
        String propertyClassName = colJson.getString(PROPERTY_CLASS_NAME);
        Validate.notBlank(
            propertyClassName, String.format("一般属性字段%s中未标注类型！", colJson.getString(PROPERTY_NAME)));
      }
      // 如果数据类型为 数据视图
      if (dataType.equals(VIEW)) {
        JSONObject viewJson = colJson.getJSONObject(dataType);
        Boolean isMany = viewJson.getBoolean(IS_MANY);
        Validate.notNull(isMany, "%s列该数据视图缺少isMany属性");
        String viewPropertyName = viewJson.getString(PROPERTY_NAME);
        Validate.notBlank(viewPropertyName, String.format("第%s列中未标注数据视图选中属性名！", index));
      }
      // 如果数据类型为字典
      if (dataType.equals(DICT)) {
        JSONObject dictJson = colJson.getJSONObject(dataType);
        Validate.notNull(dictJson, "所设定的字典类不能为空！");
        Validate.notBlank(dictJson.getString(DICT_CODE), "所设定的字典编码不能为空");
        Page<DictVo> dicts =
            dictService.findByConditions(
                dictJson.getString(DICT_CODE), null, null, null, PageRequest.of(0, 50));
        Validate.notNull(dicts, "所查询的字典不能为空！");
        Validate.isTrue(dicts.getTotalElements() == 1, "根据编码查询出的字典不唯一，请检查！");
        DictVo dict = dicts.getContent().get(0);
        List<String> keys =
            dict.getDictItems().stream()
                .map(DictItemVo::getDictKey)
                .collect(Collectors.toList());
        Validate.notEmpty(keys, "查询出字典KEY不能为空，请检查！");
      }

      // 如果数据类型为本地数据
      if (dataType.equals(LOCAL)) {
        JSONObject kvJson = colJson.getJSONObject(dataType);
        String keysStr = kvJson.getString(KEYS);
        String valuesStr = kvJson.getString(VALUES);
        Validate.notNull(keysStr, "属性设定的key不能为空！");
        Validate.notNull(valuesStr, "属性设定的values不能为空！");
        List<String> keys = Arrays.asList(StringUtils.split(keysStr, ","));
        List<String> values = Arrays.asList(StringUtils.split(valuesStr, ","));
        Validate.isTrue(keys.size() == values.size(), "传入本地数据键值对不匹配!");
      }
    }
  }

  /**
   * 为表格写入首行信息
   *
   * @param sheet
   * @param rowNum
   * @param item
   * @return
   */
  private HSSFSheet writeHEAD(HSSFSheet sheet, Integer rowNum, TemplateItemEntity item) {
    HSSFRow headRow = sheet.createRow(rowNum);
    headRow.createCell(0).setCellValue("明细名称：");
    headRow.createCell(1).setCellValue(item.getPropertyName());
    headRow.createCell(2).setCellValue("明细描述：");
    headRow.createCell(3).setCellValue(item.getPropertyDesc());
    headRow.createCell(4).setCellValue("时间：");
    headRow.createCell(5).setCellValue(new Date().toString());
    return sheet;
  }

  /**
   * 查询静态模版明细数据-使用数据视图
   *
   * @param jsonObject
   * @return
   */
  private HSSFWorkbook downloadStaticItems(JSONObject jsonObject) {
    HSSFWorkbook workbook = new HSSFWorkbook();
    // 如果为静态模版，则需要指定一个数据源-数据视图
    String dataViewCode = jsonObject.getString(DATA_VIEW_CODE);
    DataViewEntity dataView = dataViewService.findDetailsByCode(dataViewCode);
    Validate.notNull(dataView, "未找到所设定的数据视图，请检查！");
    String dataSourceCode = jsonObject.getString(DATA_SOURCE_CODE);
    String nativeSql = dataView.getSourceSql();
    // 判断原生SQL是否含有 WHERE 条件，若无，则在其后添加上
    JSONArray paramsArray = jsonObject.getJSONArray(PARAMS);
    if (!CollectionUtils.isEmpty(paramsArray)) {
      List<JSONObject> paramsList = paramsArray.toJavaList(JSONObject.class);
      // 替换数据视图SQL中的参数
      for (JSONObject o : paramsList) {
        String paramName = o.getString(NAME);
        String paramValue = o.getString(VALUE);
        String replaceParamName = String.format("{:%s}", paramName);
        String replaceParamValue = String.format("'%s'", paramValue);
        nativeSql = nativeSql.replace(replaceParamName, replaceParamValue);
      }
    }
    // 如果 dataSourceCode 为空，则说明是本地数据源，
    if (StringUtils.isBlank(dataSourceCode)) {
      List<?> result = tableOperateRepositoryCustom.executeQuerySql(nativeSql);
      HSSFSheet sheet = workbook.createSheet();
      int rowIndex = 0;
      for (Object obj : result) {
        HSSFRow row = sheet.createRow(rowIndex);
        String objJsonStr = JSON.toJSONString(obj);
        List<String> jsonArray = JSON.parseArray(objJsonStr, String.class);
        if (!CollectionUtils.isEmpty(jsonArray)) {
          for (int i = 0; i < jsonArray.size(); i++) {
            row.createCell(i).setCellValue(jsonArray.get(i));
          }
        }
        rowIndex = rowIndex + 1;
      }
    } else {
      // 验证第三方数据源
      SessionFactory sessionFactory =
          this.dynamicDataSourceManager.getCurrentSessionFactory(dataSourceCode);
      Validate.notNull(sessionFactory, "未找到该数据源！");
      DataSource dataSource = SessionFactoryUtils.getDataSource(sessionFactory);
      HSSFSheet sheet = workbook.createSheet();
      try (Connection connection = dataSource.getConnection();
          Statement statement = connection.createStatement();
          ResultSet result = statement.executeQuery(nativeSql)) {
        int rowIndex = 0;
        while (result.next()) {
          HSSFRow row = sheet.createRow(rowIndex);
          String objJsonStr = JSON.toJSONString(result.getObject(rowIndex));
          List<String> jsonArray = JSON.parseArray(objJsonStr, String.class);
          if (!CollectionUtils.isEmpty(jsonArray)) {
            for (int i = 0; i < jsonArray.size(); i++) {
              row.createCell(i).setCellValue(jsonArray.get(i));
            }
          }
          rowIndex = rowIndex + 1;
        }
      } catch (SQLException e) {
        throw new IllegalStateException("SQL执行异常，请检查!详情：" + e.getMessage());
      }
    }

    return workbook;
  }

  /**
   * 查询动态模版，直接根据JSON给出字段查询SQL
   *
   * @param jsonObject
   * @param sheet
   * @param propertySort
   */
  private void downloadDynamicItems(
      JSONObject jsonObject, HSSFSheet sheet, List<JSONObject> propertySort) {
    List<?> result = this.queryDynamicItems(jsonObject);
    // 5===
    // 从JSON中得到 属性名 - 属性类型 的KV对,填入每行数据
    Integer rowNum = 2;
    for (Object resultRow : result) {
      String strJson = JSON.toJSONString(resultRow);
      List<String> strList = JSON.parseArray(strJson, String.class);
      HSSFRow row = sheet.getRow(rowNum);
      for (Integer colNum = 0; colNum < strList.size(); colNum++) {
        JSONObject colJson = propertySort.get(colNum);
        String dataType = colJson.getString(DATE_TYPE);

        // 如果该列数据类型为一般属性字段，
        if (dataType.equals(NORMAL)) {
          row.getCell(colNum).setCellValue(strList.get(colNum));
        }
        // 如果数据类型为 数据视图
        if (dataType.equals(VIEW)) {
          row.getCell(colNum).setCellValue(strList.get(colNum));
        }
        // 如果数据类型为字典
        if (dataType.equals(DICT)) {
          JSONObject dictJson = colJson.getJSONObject(DICT);
          Page<DictVo> dicts =
              dictService.findByConditions(
                  dictJson.getString(DICT_CODE), null, null, null, PageRequest.of(0, 50));
          DictVo dict = dicts.getContent().get(0);
          List<String> keys =
              dict.getDictItems().stream()
                  .map(DictItemVo::getDictKey)
                  .collect(Collectors.toList());
          List<String> values =
              dict.getDictItems().stream()
                  .map(DictItemVo::getDictKey)
                  .collect(Collectors.toList());
          //
          if (values.contains(strList.get(colNum))) {
            String key = keys.get(values.indexOf(strList.get(colNum)));
            row.getCell(colNum).setCellValue(key);
          } else {
            row.getCell(colNum).setCellValue(strList.get(colNum));
          }
        }
        // 方法源
        if (dataType.equals(SERVICE)) {
          row.getCell(colNum).setCellValue(strList.get(colNum));
        }
        // 本地数据
        if (dataType.equals(LOCAL)) {
          JSONObject kvJson = colJson.getJSONObject(dataType);
          String keysStr = kvJson.getString(KEYS);
          String valuesStr = kvJson.getString(VALUES);
          List<String> keys = Arrays.asList(StringUtils.split(keysStr, ","));
          List<String> values = Arrays.asList(StringUtils.split(valuesStr, ","));
          if (values.contains(strList.get(colNum))) {
            String key = keys.get(values.indexOf(strList.get(colNum)));
            row.getCell(colNum).setCellValue(key);
          } else {
            row.getCell(colNum).setCellValue(strList.get(colNum));
          }
        }
      }
      rowNum = rowNum + 1;
    }
  }

  /**
   * 查询数据库中当前明细数据
   *
   * @param jsonObject
   * @return
   */
  private List<?> queryDynamicItems(JSONObject jsonObject) {
    String itemId = jsonObject.getString(TEMPLATE_ITEM_ID);
    String parentId = jsonObject.getString(PARRENT_ID);
    TemplateItemEntity item = templateItemService.findDetailsById(itemId);
    // 查询时动态静态分开处理
    if (item.getType().equals(STATIC)) {
      // 如果为静态模版，则需要指定一个数据源-数据视图
      String dataViewCode = jsonObject.getString(DATA_VIEW_CODE);
      DataViewEntity dataView = dataViewService.findDetailsByCode(dataViewCode);
      Validate.notNull(dataView, "未找到所设定的数据视图，请检查！");

      String tableName = item.getTableName();
      // 从 manyToOne 关系中获取该明细的父类ID
      List<TemplateRelationEntity> relation =
          item.getRelations().stream()
              .filter(o -> item.getParentClassName().equals(o.getPropertyClassName()))
              .collect(Collectors.toList());
      Validate.notEmpty(relation,"该静态模型明细属性缺失上层关联，请检查！");
      Validate.isTrue(relation.size() == 1, "该静态模型明细属性上层关联不匹配，请检查！");
      // 验证字段根据index排序
      List<JSONObject> propertySort = this.getSortProperties(jsonObject, PROPERTIES, INDEX);
      List<String> propertyDbName =
          propertySort.stream()
              .map(o -> o.getString(PROPERTY_DB_NAME))
              .collect(Collectors.toList());
      return instanceItemImportRepository.queryDynamicItems(propertyDbName,tableName,relation.get(0).getPropertyDbName(),parentId);
    }
    if (item.getType().equals(DYNAMIC)) {
      String tableName = item.getTableName();
      // 直接获取 父级表关联字段
      String parrentTableName = String.format("%s_id", item.getParentTableName());
      List<JSONObject> propertySort = this.getSortProperties(jsonObject, PROPERTIES, INDEX);
      List<String> propertyDbName =
          propertySort.stream()
              .map(o -> o.getString(PROPERTY_DB_NAME))
              .collect(Collectors.toList());
      return instanceItemImportRepository.queryDynamicItems(propertyDbName,tableName,parrentTableName,parentId);
    }
    return Lists.newArrayList();
  }

  private Map<Integer, String> addSeviceMethodError(
      Map<Integer, String> exist, List<String> errors, List<Integer> indexes) {
    if (CollectionUtils.isEmpty(indexes) || CollectionUtils.isEmpty(errors)) {
      return exist;
    }
    for (int i = 0; i < indexes.size(); i++) {
      exist.put(indexes.get(i), errors.get(i));
    }
    return exist;
  }
}
