package com.bizunited.platform.kuiper.starter.service.migrate;

import com.bizunited.platform.kuiper.entity.MigrateImportEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * MigrateImportServiceImpl
 * @description: 基本信息迁入功能的实现
 * @author: yanwe
 * @date: 03/Sep/2019 15:45
 */
@Service("MigrateImportService")
public interface MigrateImportService {
  /**
   * 上传ZIP文件，保存上传记录
   *
   * @param file 文件
   * @param dataType
   * @return
   */
  MigrateImportEntity upload(MultipartFile file, Integer dataType);
  /**
   * 保存方法
   *
   * @param migrateImportEntity
   * @return
   */
  MigrateImportEntity create(MigrateImportEntity migrateImportEntity);

  /**
   * 根据数据类型查询导入日志
   * @param dataType
   * @return
   */
  List<MigrateImportEntity> findDetailsByDataType(Integer dataType);

  /**
   * 根据ID查询详情
   * @param id
   * @return
   */
  MigrateImportEntity findDetailsById(String id);

  /**
   * 执行导入
   * @param id
   * @param mode
   * @return
   */
  MigrateImportEntity execute(String id, Integer mode);

}