package com.bizunited.platform.kuiper.starter.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import org.springframework.context.annotation.Import;

import com.bizunited.platform.core.configuration.PlatformCoreConfig;
import com.bizunited.platform.kuiper.starter.configuration.KuiperServiceConfig;

/**
 * 使用该标识性质的注解，标记在业务工程的Service层，
 * 表示这个service可以通过表单引擎直接向表单模板开放
 * @author yinwenjie
 */
@Retention(value = java.lang.annotation.RetentionPolicy.RUNTIME)
@Target(value = { java.lang.annotation.ElementType.TYPE })
@Documented
@Import({KuiperServiceConfig.class , PlatformCoreConfig.class})
public @interface EnableKuiperService {

}
