package com.bizunited.platform.kuiper.starter.common.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * excel工具使用常量
 *
 * @author Keller
 * @create 2020/8/24
 */
public class ExcelConstants {

  public static Map<Character, Integer> columnMap = new HashMap<Character, Integer>();

  /**
   * excel2003文件后缀
   */
  public static final String EXCEL_XLS_END = ".xls";

  /**
   * excel2007文件后缀
   */
  public static final String EXCEL_XLSX_END = ".xlsx";

  /**
   * 读取模型 基于事件的模型
   */
  public static final Integer READE_MODEL_EVENT = 0;
  /**
   * 普通模型
   */
  public static final Integer READE_MODEL_DOM = 1;

  /**
   * excel组件标识单元格标识
   */
  public static final String EXCEL_CELL_FLAG = "c";

  /**
   * 单元格位置
   */
  public static final String EXCEL_REF_FLAG = "r";

  /**
   * excel组件标识
   */
  public static final String EXCEL_ELEMENT_FLAG = "t";

  /**
   * excel单元格类型
   */
  public static final String EXCEL_TYPE_FLAG = "t";

  /**
   * excel单元格样式
   */
  public static final String EXCEL_STYLE_FLAG = "c";

  /**
   * excel单元格值标识
   */
  public static final String EXCEL_VALUE_FALG = "v";

  /**
   * excel行名标识
   */
  public static final String EXCEL_ROW_FALG = "row";

  /**
   * excel单元格格式布尔型标识
   */
  public static final String EXCEL_CELL_TYPE_BOOLEAN = "b";

  /**
   * excel单元格格式错误标识
   */
  public static final String EXCEL_CELL_TYPE_ERROR = "e";

  /**
   * excel单元格格式公式标识
   */
  public static final String EXCEL_CELL_TYPE_FORMULA = "str";

  /**
   * excel单元格格式行内字符标识
   */
  public static final String EXCEL_CELL_TYPE_INLINESTR = "inlineStr";

  /**
   * excel单元格格式字符串标识
   */
  public static final String EXCEL_CELL_TYPE_STR = "s";

  static {
    columnMap.put('A', 1);
    columnMap.put('B', 2);
    columnMap.put('C', 3);
    columnMap.put('D', 4);
    columnMap.put('E', 5);
    columnMap.put('F', 6);
    columnMap.put('G', 7);
    columnMap.put('H', 8);
    columnMap.put('I', 9);
    columnMap.put('J', 10);
    columnMap.put('K', 11);
    columnMap.put('L', 12);
    columnMap.put('M', 13);
    columnMap.put('N', 14);
    columnMap.put('O', 15);
    columnMap.put('P', 16);
    columnMap.put('Q', 17);
    columnMap.put('R', 18);
    columnMap.put('S', 19);
    columnMap.put('T', 20);
    columnMap.put('U', 21);
    columnMap.put('V', 22);
    columnMap.put('W', 23);
    columnMap.put('X', 24);
    columnMap.put('Y', 25);
    columnMap.put('Z', 26);
  }
}
