package com.bizunited.platform.kuiper.starter.common.excel;

import java.util.ArrayList;
import java.util.List;

/**
 * ExcelImportVo 本VO用于构造EXCEL上传明细中，服务源的返回体
 *
 * @description:
 * @author: yanwe
 * @date: 15/Aug/2019 16:48
 */

public class ExcelImportVo {

  private List<Object> objects = new ArrayList<>();

  private List<String> errorMsgs = new ArrayList<>();

  private List<Integer> errorIndexs = new ArrayList<>();

  private String totalError = "";

  /**
   * 添加一个返回的实体
   *
   * @param object 实体
   */
  public void addObject(Object object) {
    this.objects.add(object);
  }

  /**
   * 移除一个返回的实体
   *
   * @param index 数组下标
   */
  public void rmObject(int index) {
    this.objects.remove(index);
  }

  /**
   * 添加一个错误信息
   *
   * @param index    excel行数
   * @param errorMsg 错误信息
   */
  public void addError(Integer index, String errorMsg) {
    this.errorIndexs.add(index);
    this.errorMsgs.add(errorMsg);
  }

  /**
   * 移除一个错误信息
   *
   * @param index 数组下标
   */
  public void rmError(int index) {
    this.errorIndexs.remove(index);
    this.errorMsgs.remove(index);
  }

  /**
   * 设置全局错误信息
   *
   * @param totalError
   */
  public void setTotalError(String totalError) {
    this.totalError = totalError;
  }

  public List<Object> getObjects() {
    return objects;
  }

  public List<String> getErrorMsgs() {
    return errorMsgs;
  }

  public List<Integer> getErrorIndexs() {
    return errorIndexs;
  }

  public String getTotalError() {
    return totalError;
  }
}
