package com.bizunited.platform.kuiper.starter.configuration;

import java.util.concurrent.TimeUnit;

import com.github.benmanes.caffeine.cache.Caffeine;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;


/**
 * 结合本地cache注解，集成ecache本地缓存组件
 * @author yinwenjie
 */
@Configuration
public class EcacheManagerConfig {
  @Bean
  @ConditionalOnMissingBean
  public CacheManager getCacheManager() {
    Caffeine<Object, Object> caffeine = Caffeine.newBuilder()
        .initialCapacity(100)
        .maximumSize(1000)
        .expireAfterWrite(10,TimeUnit.SECONDS);

    CaffeineCacheManager cacheManager = new CaffeineCacheManager();
    cacheManager.setAllowNullValues(false);
    cacheManager.setCaffeine(caffeine);
    return cacheManager;
  }
}