package com.bizunited.platform.kuiper.starter.configuration;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;


/**
 * @author Keller
 * @create 2020/8/25
 */
@EnableAsync
@Configuration
public class FromDetailsMigrateTaskConfiguration {

  /**
   * 导入导出任务异步线初始程池数
   */
  @Value("${kuiper.migrate.pool.core-size:1}")
  private Integer coreSize;

  /**
   * 导入导出任务异步线最大程池数
   */
  @Value("${kuiper.migrate.pool.max-size:2}")
  private Integer maxSize;

  @Bean("fromDetailsMigrateExecutor")
  public ThreadPoolTaskExecutor taskExecutor() {
    ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
    executor.setCorePoolSize(coreSize);
    executor.setMaxPoolSize(maxSize);
    executor.setQueueCapacity(0);
    executor.setThreadNamePrefix("migrate-task-executor-");
    executor.setAwaitTerminationSeconds(10);
    executor.setWaitForTasksToCompleteOnShutdown(true);
    executor.initialize();
    return executor;
  }
}
