package com.bizunited.platform.kuiper.starter.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.InstanceItemImportEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemExcelEntity;
import com.bizunited.platform.kuiper.starter.service.InstanceItemImportService;
import com.bizunited.platform.kuiper.starter.service.TemplateItemExcelService;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.security.Principal;

/**
 * InstanceItemImportController
 * @description:
 * @author: weitongyan
 * @date: 16/Apr/2019 16:11
 */
@RestController
@RequestMapping("/v1/kuiper/instancesItemImport")
public class InstanceItemImportController extends  BaseController{

  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(InstanceItemImportController.class);

  @Autowired
  private InstanceItemImportService instanceItemImportService;
  @Autowired
  private TemplateItemExcelService templateItemExcelService;
  @Autowired
  private VenusFileService venusFileService;


  @ApiOperation(value = "上传导入模版")
  @PostMapping("/uploadExample")
  public ResponseModel uploadExample(
          @RequestParam("templateItemId") String templateItemId,
          @RequestParam("sheetNum") Integer sheetNum,
          @RequestParam("rowNum") Integer rowNum,
          @RequestParam("file") MultipartFile file){
    try {
      Principal opUser = this.getPrincipal();
      JSONObject jsonResult = this.instanceItemImportService.uploadExample(templateItemId,file,sheetNum,rowNum,opUser);
      return this.buildHttpResultW(jsonResult);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }


  @ApiOperation(value = "导入明细数据")
  @PostMapping("/upload")
  public ResponseModel upload(@ApiParam(name = "json", value = "表单验证格式JSON") @RequestParam("json") String jsonObject,
                              HttpServletRequest request , HttpServletResponse response ,
                              @ApiParam(name = "file", value = "上传文件") @RequestParam("file") MultipartFile file,
                              @ApiParam(name = "sheetNum", value = "读入EXCEL第N页，若无，则默认读入第1页") @RequestParam("sheetNum") Integer sheetNum,
                              @ApiParam(name = "startRow", value = "从第N行开始读入数据，若无则默认为2") @RequestParam("startRow") Integer startRow,
                              @ApiParam(name = "endRow", value = "数据读至第N行，若无，则往下读至空白行") @RequestParam("endRow") Integer endRow,
                              @ApiParam(name = "instanceId", value = "表单实例的ID") @RequestParam("instanceId") String instanceId,
                              @ApiParam(name = "paramsJson", value = "干预源参数json格式") @RequestParam("paramsJson") String paramsJson){
    try {
      Principal opUser = this.getPrincipal();
      JSONObject jsonResult = this.instanceItemImportService.upload(JSON.parseObject(jsonObject),request,response,file,sheetNum,startRow,endRow,opUser,instanceId,paramsJson);
      return this.buildHttpResultW(jsonResult);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "分页查询明细导入记录")
  @GetMapping("/findItemImport")
  public ResponseModel findItemImport(@ApiParam(name = "templateItemId", value = "表单明细模版Id") @RequestParam("templateItemId") String templateItemId, Pageable pageable){
    try {
      Page<InstanceItemImportEntity> instanceItemImportEntities = this.instanceItemImportService.queryPage(templateItemId,pageable);
      return this.buildHttpResultW(instanceItemImportEntities);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "导出实例明细数据")
  @PostMapping("/downloadItems")
  public ResponseModel downloadItems(@RequestBody @ApiParam(name = "templateItemInfo", value = "表单明细数据信息") JSONObject jsonObject, HttpServletResponse response){
    try {
      this.instanceItemImportService.downloadItems(jsonObject,response);
      return this.buildHttpResult();
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "按照表单模板明细ID，下载EXCEL文件。")
  @GetMapping("/download")
  public void downloadExcelTemplate(
      HttpServletResponse response,HttpServletRequest request,
      @ApiParam(name = "templateItemId", value = "表单模板明细ID") @RequestParam("templateItemId")
          String templateItemId){
    if(StringUtils.isBlank(templateItemId)){
      return;
    }
    TemplateItemExcelEntity itemExcel = templateItemExcelService.findByTemplateItem(templateItemId);
    if(itemExcel == null){
      return;
    }
    byte[] fileByte = venusFileService.readFileContent(itemExcel.getFilePath(),itemExcel.getFileName());
    if (fileByte == null) {
      return;
    }
    // 附件文件下载
    this.writeResponseFile(request,response, fileByte, itemExcel.getOriginalFileName());
  }


}
