package com.bizunited.platform.kuiper.starter.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.TemplateLayoutEntity;
import com.bizunited.platform.kuiper.starter.service.TemplateLayoutService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;

@Api(value = "TemplateLayoutController")
@RestController
@RequestMapping("/v1/kuiper/templateLayouts")
class TemplateLayoutController extends BaseController {
  private static final Logger LOGGER = LoggerFactory.getLogger(TemplateLayoutController.class);
  @Autowired
  private TemplateLayoutService templateLayoutService;

  @ApiOperation(value = "根据指定模板查询表单布局")
  @GetMapping("/findDetailsByTemplateId")
  public ResponseModel findDetailsByTemplateId(@ApiParam(name = "templateId", value = "模板编号") @RequestParam("templateId") String templateId ,
                                               @ApiParam(name = "layoutType", value = "布局类型：1.PC端；2.mobile端；3.print端 （可以不传入，如果不传入则默认查询定义的PC端样式）" , required = false) @RequestParam(name = "layoutType" , required = false) Integer layoutType) {
    try {
      JSONObject layout = templateLayoutService.findDetailsByTemplateId(templateId , layoutType);
      return this.buildHttpResult(layout);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
  
  /**
   * 根据模板编号保存当前模板的各种类型的布局信息
   * @param templateId 模板编号
   * @param layoutType 布局类型：1.PC端；2.mobile端；3.print端（可以不传入，如果不传入则默认查询定义的PC端样式）
   * @param layout 表单布局
   * @return
   */
  @ApiOperation(value = "根据模板编号保存当前模板的各种类型的布局信息" , notes = "默认情况下并不推荐使用该方法进行创建/更新操作")
  @RequestMapping(value = "", method = {RequestMethod.POST , RequestMethod.PATCH})
  public ResponseModel save(@ApiParam(name = "templateId", value = "模板编号") @RequestParam("templateId") String templateId ,
                                   @ApiParam(name = "layoutType", value = "布局类型：1.PC端；2.mobile端；3.print端") @RequestParam("layoutType") Integer layoutType ,
                                   @ApiParam(name = "layout", value = "模板布局的json结构") @RequestBody JSONObject layout) throws IOException {
    try {
      TemplateLayoutEntity result = templateLayoutService.save(templateId, layoutType, layout);
      return this.buildHttpResult(result);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
}
