package com.bizunited.platform.kuiper.starter.repository;
import com.bizunited.platform.kuiper.entity.DynamicTemplateDraftEntity;

import com.bizunited.platform.kuiper.starter.repository.dynamic.DynamicTemplateDraftRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * 动态模板草稿功能的数据库方法支持
 * @author saturn
 */
@Repository("DynamicTemplateDraftRepository")
public interface DynamicTemplateDraftRepository
        extends
        JpaRepository<DynamicTemplateDraftEntity, String>
        , JpaSpecificationExecutor<DynamicTemplateDraftEntity>, DynamicTemplateDraftRepositoryCustom {

  /**
   * 按照主键进行详情查询（包括关联信息），这里查询的是
   *
   * @param id 主键
   */
  @Query("from DynamicTemplateDraftEntity dynamicTemplateDraftEntity "
          + " where dynamicTemplateDraftEntity.id=:id ")
  DynamicTemplateDraftEntity findDetailsById(@Param("id") String id);

  /**
   * 按照业务名/业务编号进行查询
   *
   * @param code 业务名/业务编号
   */
  DynamicTemplateDraftEntity findByCode(String code);

  /**
   * 按照动态模板设定的数据表名进行查询
   *
   * @param tableName 动态模板设定的数据表名
   */
  DynamicTemplateDraftEntity findByTableName(String tableName);

  /**
   * 根据业务编码统计数量，根据ID排除
   * @param id
   * @param code
   * @return
   */
  @Query("select count(*) from DynamicTemplateDraftEntity d where d.code = :code and d.id <> :id ")
  Long countByCodeWithoutId(@Param("id") String id, @Param("code") String code);

  /**
   * 根据业务编码统计数量，根据ID排除
   * @param id
   * @param tableName
   * @return
   */
  @Query("select count(*) from DynamicTemplateDraftEntity d where d.tableName = :tableName and d.id <> :id ")
  Long countByTableNameWithoutId(@Param("id") String id, @Param("tableName") String tableName);

}