package com.bizunited.platform.kuiper.starter.repository;

import com.bizunited.platform.kuiper.entity.FormDetailsImportBoxEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * @author Keller
 * @create 2020/8/23
 */
@Repository("FormDetailsImportBoxRepository")
public interface FormDetailsImportBoxRepository extends
        JpaRepository<FormDetailsImportBoxEntity, String>,
        JpaSpecificationExecutor<FormDetailsImportBoxEntity> {

  @Query("from FormDetailsImportBoxEntity t where t.isDelete=:isDelete and t.executor=:account and t.projectName=:projectName")
  Page<FormDetailsImportBoxEntity> queryPageByDelete(@Param("isDelete") Boolean isDelete, @Param("account") String account, @Param("projectName") String projectName, Pageable pageable);

  @Modifying
  @Query("update FormDetailsImportBoxEntity t set t.isDelete = true where t.isDelete = false and t.executor=:account and t.projectName=:projectName")
  void deleteAll(@Param("projectName") String projectName, @Param("account") String account);

}
