package com.bizunited.platform.kuiper.starter.repository;

import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.kuiper.entity.InstanceActivityLogEntity;

@Repository("InstanceActivityLogRepository")
public interface InstanceActivityLogRepository
    extends
      JpaRepository<InstanceActivityLogEntity, String>,
      JpaSpecificationExecutor<InstanceActivityLogEntity> {  
  /**
   * 查询指定活动实例下的数据变化日志(包括日志关联的详细信息)，并按照时间顺序进行返回
   * @param instanceActivityId 活动实例编号
   * @return
   */
  @Query("from InstanceActivityLogEntity log "
      + " left join fetch log.instanceActivity inc "
      + " where inc.id = :instanceActivityId order by log.createTime DESC ")
  public Set<InstanceActivityLogEntity> findDetailsByInstanceActivity(@Param("instanceActivityId") String instanceActivityId);
  
  /**
   * 查询指定活动实例下的数据变化日志，并按照时间顺序进行返回
   * @param instanceActivityId 活动实例编号
   * @return
   */
  @Query("from InstanceActivityLogEntity log "
      + " left join fetch log.instanceActivity inc "
      + " where inc.id = :instanceActivityId order by log.createTime DESC ")
  public Set<InstanceActivityLogEntity> findByInstanceActivity(@Param("instanceActivityId") String instanceActivityId);
  
  /**
   * 查询指定活动变化日志的详情，注意，这里只是查询数据库中存储的信息，并不包括变化日志的json结构信息
   * @param instanceActivityLogId 指定的实例活动变化日志编号
   * @return
   */
  @Query(" from InstanceActivityLogEntity log "
      + " left join fetch log.instanceActivity inc "
      + " where log.id = :instanceActivityLogId ")
  public InstanceActivityLogEntity findDetailsById(@Param("instanceActivityLogId") String instanceActivityLogId);

  /**
   * 按照当前表单实例，查询该表单实例下的所有活动日志信息，并按照时间顺序进行进行倒序
   * @param instanceId 表单实例编号
   * @return
   */
  @Query(" from InstanceActivityLogEntity log "
          + " left join fetch log.instanceActivity ina "
          + " left join fetch ina.instance inc "
          + " where inc.id = :instanceId order by log.createTime DESC ")
  public Set<InstanceActivityLogEntity> findByInstanceId(@Param("instanceId") String instanceId);

/**
   * 按照指定的实例编号，查询这个实例编号下最后一次发生的数据变化日志
   * @param instanceId 指定的实例编号
   * @return
   */
  @Query(value="select l.id as id from engine_form_instance_activity_log l "
      + " left join engine_form_instance_activity ac on l.instance_activity_id = ac.id "
      + " left join engine_form_instance ins on ins.id = ac.instance_id "
      + " where ins.id = :instanceId order by l.create_time desc LIMIT 1" , nativeQuery=true)
  public String findTopByInstanceId(@Param("instanceId") String instanceId);
  
  /**
   * 按照指定的活动实例编号，查询这个活动实例编号下最后一次发生的数据变化日志
   * @param instanceActivityId 
   * @return 
   */
  @Query(value="select l.id as id from engine_form_instance_activity_log l "
          + " left join engine_form_instance_activity ac on l.instance_activity_id = ac.id "
          + " where ac.id = :instanceActivityId order by l.create_time desc LIMIT 1" , nativeQuery=true)
  public String findTopByInstanceActivityId(@Param("instanceActivityId") String instanceActivityId);

/**
   * 真删除日志信息 
   * @param instanceActivityLogId
   */
  @Modifying
  @Query(value="delete from engine_form_instance_activity_log where id = :instanceActivityLogId" , nativeQuery=true)
  public void deleteById(@Param("instanceActivityLogId") String instanceActivityLogId);
}