package com.bizunited.platform.kuiper.starter.repository;

import com.bizunited.platform.kuiper.entity.PageEventEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * 页面事件持久化接口定义
 * @Author: Paul Chan
 * @Date: 2019-12-31 16:38
 */
@Repository("PageEventRepository")
public interface PageEventRepository extends JpaRepository<PageEventEntity, String>, JpaSpecificationExecutor<PageEventEntity> {

  /**
   * 根据页面ID查询
   * @param pageId
   */
  @Query("select pe from PageEventEntity pe inner join pe.page p where p.id = :pageId ")
  Set<PageEventEntity> findByPageId(@Param("pageId") String pageId);

  /**
   * 根据页面流编码和页面编码和事件ID查询
   *
   * @param pageFlowCode
   * @param pageCode
   * @param eventId
   * @return
   */
  @Query("select pe from PageEventEntity pe " +
      " inner join fetch pe.page p " +
      " inner join fetch p.pageFlow pf " +
      " where pf.code = :pageFlowCode and p.code = :pageCode and pe.eventId = :eventId ")
  PageEventEntity findDetailByPageFlowCodeAndPageCodeAndEventId(@Param("pageFlowCode") String pageFlowCode, @Param("pageCode") String pageCode, @Param("eventId") String eventId);
}
