package com.bizunited.platform.kuiper.starter.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.kuiper.entity.TemplateStyleEntity;

@Repository("TemplateStyleRepository")
public interface TemplateStyleRepository
    extends
      JpaRepository<TemplateStyleEntity, String>,
      JpaSpecificationExecutor<TemplateStyleEntity> {
  
  /**
   * 查询目前系统中所有定义的样式信息，无论样式信息处于什么状态。并按照创建时间进行倒序排列
   * */
  @Query("from TemplateStyleEntity tse where tse.projectName = :projectName order by tse.createTime desc ")
  public List<TemplateStyleEntity> findAllByProjectName(@Param("projectName") String projectName);
  /**
   * 按照指定的状态条件，查询符合状态的样式信息
   * @param tstatus 1：状态正确；0：状态异常
   * @return
   */
  @Query("from TemplateStyleEntity tse where tse.tstatus =:tstatus and tse.projectName = :projectName order by tse.createTime desc ")
  public List<TemplateStyleEntity> findByTstatusAndProjectName(@Param("tstatus") Integer tstatus, @Param("projectName") String projectName);
  /**
   * 查询目前系统中，指定样式数据编号的样式基本信息
   * @param id 指定的样式编号信息
   */
  @Query("from TemplateStyleEntity tse where tse.id = :id")
  public TemplateStyleEntity findDetailsById(@Param("id") String id);
  
  /**
   * 查询目前系统中，指定样式业务编号（code）的样式基本信息
   * @param id 指定的样式编号信息
   */
  @Query("from TemplateStyleEntity tse where tse.code = :code ")
  public TemplateStyleEntity findDetailsByCode(@Param("code") String code);
}
