package com.bizunited.platform.kuiper.starter.repository;


import com.bizunited.platform.kuiper.entity.TemplateVisibilityButtonsEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import java.util.Set;

@Repository("TemplateVisibilityButtonRepository")
public interface TemplateVisibilityButtonRepository extends JpaRepository<TemplateVisibilityButtonsEntity, String>, JpaSpecificationExecutor<TemplateVisibilityButtonsEntity> {
  /**
   * 根据表单可见性id查询按钮信息
   * @param visibilityId 表单可见性id
   * @return
   */
  @Query(value = "select evb from TemplateVisibilityButtonsEntity evb "
   + "left join fetch evb.templateVisibility tv where tv.id = :visibilityId ")
  Set<TemplateVisibilityButtonsEntity> findByVisiblId(@Param("visibilityId") String visibilityId);

  @Query(value = "select count(*) from engine_form_visibility_buttons evb where evb.visibility_id = :visibilityId and evb.controller_id = :controllerId ", nativeQuery = true)
  int countButtController(@Param("visibilityId") String visibilityId, @Param("controllerId") String controllerId);
  
  /**
   * 按照指定的可见性，删除指定可见性下的所有按钮定义信息
   * @param templateVisibilityId 指定的可见性编号
   */
  public void deleteByTemplateVisibilityId(@Param("templateVisibilityId") String templateVisibilityId);

  /**
   * 根据可见性ID和布局查询按钮
   * @param visibilityId
   * @param layoutType
   * @return
   */
  @Query("select vb from TemplateVisibilityButtonsEntity vb inner join vb.templateVisibility v " +
      " where v.id = :visibilityId and vb.layoutType = :layoutType ")
  Set<TemplateVisibilityButtonsEntity> findByVisibilityIdAndLayoutType(@Param("visibilityId") String visibilityId, @Param("layoutType") Integer layoutType);

}
