package com.bizunited.platform.kuiper.starter.repository.internal;

import com.bizunited.platform.kuiper.entity.FrontFileEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository("FrontFileRepositoryCustom")
public interface FrontFileRepositoryCustom {

  /**
   * 分页查询
   * @param pageable
   * @param conditions
   * @return
   */
  Page<FrontFileEntity> queryPage(Pageable pageable, Map<String, Object> conditions);

  /**
   * 不分页查询
   * @param conditions
   * @return
   */
  List<FrontFileEntity> findAllByConditions(Map<String, Object> conditions);
}
