package com.bizunited.platform.kuiper.starter.repository.internal;

import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.kuiper.entity.InstanceItemImportEntity;
import com.bizunited.platform.kuiper.starter.repository.table.TableOperateRepositoryCustom;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

/**
 * InstanceItemImportRepositoryImpl
 * @description:
 * @author: weitongyan
 * @date: 12/Apr/2019 11:20
 */
@Repository("InstanceItemImportRepositoryImpl")
public class InstanceItemImportRepositoryImpl implements InstanceItemImportRepositoryCustom {
  private static final String MESS_TEMPLATE_ITEM = "templateItemId";
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;

  @Autowired private TableOperateRepositoryCustom tableOperateRepositoryCustom;

  @Override
  @SuppressWarnings("unchecked")
  public Page<InstanceItemImportEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {

    String hql = "from InstanceItemImportEntity u  where 1 = 1";
    String countHql = "select count(*) from InstanceItemImportEntity u where 1 = 1";
    //筛选项目名称
    hql += " and u.projectName=:projectName ";
    countHql += " and u.projectName=:projectName ";
    Object templateItemId = conditions.get(MESS_TEMPLATE_ITEM);
    if(templateItemId != null) {
      hql += " AND u.templateItemId = :templateItemId ";
      countHql += " AND u.templateItemId = :templateItemId ";
    }


    // 构造HQL查询 和 数量查询
    Query query = this.entityManager.createQuery(hql);
    Query countQuery = this.entityManager.createQuery(countHql);
    query.setParameter("projectName", ApplicationContextUtils.getProjectName());
    countQuery.setParameter("projectName", ApplicationContextUtils.getProjectName());
    if(templateItemId != null) {
      query.setParameter(MESS_TEMPLATE_ITEM, templateItemId);
      countQuery.setParameter(MESS_TEMPLATE_ITEM, templateItemId);
    }


    // 构造分页信息
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<InstanceItemImportEntity> results = query.getResultList();

    // 查询总数量信息
    long count = (long)countQuery.getResultList().get(0);
    return new PageImpl<>(results,pageable,count);
  }

  @Override
  public List<?> queryDynamicItems(List<String> propertyDbNames, String tableName, String relationDbName, String parentId) {
    String nativeQuerySql =
        String.format(
            "SELECT %s FROM `%s` WHERE %s = '%s'",
            StringUtils.join(propertyDbNames, ","),
            tableName,
            relationDbName,
            parentId);
    return tableOperateRepositoryCustom.executeQuerySql(nativeQuerySql);
  }
}
