package com.bizunited.platform.kuiper.starter.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.kuiper.entity.InstanceEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import java.util.HashMap;
import java.util.Map;

/**
 * 表单实例持久化自定义实现
 * @Author: Paul Chan
 * @Date: 2019-12-19 18:48
 */
@Repository("InstanceRepositoryImpl")
public class InstanceRepositoryImpl implements InstanceRepositoryCustom, PageRepositoryImpl {

  @Autowired
  private EntityManager entityManager;

  @Override
  public Page<InstanceEntity> findByTemplateId(String templateId, Pageable pageable) {
    String hql = "select i from InstanceEntity i inner join fetch i.template t where t.id = :templateId  order by i.createTime desc ";
    String countHql = "select count(*) from InstanceEntity i inner join i.template t where t.id = :templateId  ";
    Map<String, Object> paramater = new HashMap<>(2);
    paramater.put("templateId", templateId);
    return queryByConditions(entityManager, hql, countHql, paramater, pageable, false, null);
  }
}
