package com.bizunited.platform.kuiper.starter.repository.internal;

import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.kuiper.entity.ListTemplateEntity;

@Repository("ListTemplateRepositoryCustom")
public interface ListTemplateRepositoryCustom {
  /**
   * 这里是针对列表模板的数据库层分页查询定义
   * @param pageable 分页信息
   * @param conditions 查询条件现在包括编号、版本、中文名信息
   * @return
   */
  Page<ListTemplateEntity> findByConditions(Pageable pageable , Map<String, Object> conditions);

  /**
   * 根据条件查询所有模版数据
   * @param condition
   * @return
   */
  List<ListTemplateEntity> findAllByConditions(ListTemplateEntity condition);
}
