package com.bizunited.platform.kuiper.starter.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 表单模版持久化自定义接口实现
 * @author yinwenjie
 */
@Repository("TemplateRepositoryImpl")
public class TemplateRepositoryImpl implements TemplateRepositoryCustom, PageRepositoryImpl {

  private static final String MESS_DEFAULT_VERSION = "isDefault";
  private static final String MESS_DOMAIN = "domain";
  private static final String MESS_PROJECT_NAME = "projectName";
  private static final String MESS_CVERSION = "cversion";
  private static final String MESS_CODE = "code";
  private static final String MESS_TSTATUS = "tstatus";
  private static final String MESS_TYPE = "type";
  private static final String MESS_CREATE_START = "createStart";
  private static final String MESS_CREATE_END = "createEnd";
  private static final String MESS_MODIFY_START = "modifyStart";
  private static final String MESS_MODIFY_END = "modifyEnd";
  private static final String MESS_NAME = "name";

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  
  /* (non-Javadoc)
   * @see com.bizunited.platform.kuiper.starter.repository.internal.TemplateRepositoryCustom#findByConditions(org.springframework.data.domain.Pageable, java.util.Map)
   */
  @Override
  public Page<TemplateEntity> findByConditions(Pageable pageable, Map<String, Object> conditions) {
    /*
     * 目前的查询条件是：表单名、业务领域、项目名、模板版本号、模板code、模板状态tstatus（1正常；0禁止/废除）
     * */
    StringBuilder hql = new StringBuilder("from TemplateEntity te left join fetch te.maintainers tem where 1=1 ");
    StringBuilder countHql = new StringBuilder("select count(*) from TemplateEntity te where 1=1 ");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameter = new HashMap<>();
    //筛选项目名称
    condition.append(" and te.projectName=:projectName ");
    parameter.put("projectName", ApplicationContextUtils.getProjectName());
    // 是否默认版本
    Object isDefault = conditions.get(MESS_DEFAULT_VERSION);
    if(isDefault != null) {
      condition.append(" AND te.defaultVersion = :defaultVersion ");
      parameter.put("defaultVersion", isDefault);
    }
    // 业务领域domain
    String domain = (String) conditions.get(MESS_DOMAIN);
    if(StringUtils.isNotBlank(domain)) {
      condition.append(" AND te.domain = :domain ");
      parameter.put(MESS_DOMAIN, domain);
    }
    // 模板版本号
    String cversion = (String) conditions.get(MESS_CVERSION);
    if(StringUtils.isNotBlank(cversion)) {
      condition.append(" AND te.cversion = :cversion ");
      parameter.put(MESS_CVERSION, cversion);
    }
    // 模板code
    String code = (String) conditions.get(MESS_CODE);
    if(StringUtils.isNotBlank(code)) {
      condition.append(" AND te.code = :code ");
      parameter.put(MESS_CODE, code);
    }
    // 模板tstatus
    Object tstatus = conditions.get(MESS_TSTATUS);
    if(tstatus != null) {
      condition.append(" AND te.tstatus = :tstatus ");
      parameter.put(MESS_TSTATUS, tstatus);
    }
    // 模板类型
    String type = (String) conditions.get(MESS_TYPE);
    if (StringUtils.isNotBlank(type)) {
      condition.append(" AND te.type = :type ");
      parameter.put(MESS_TYPE, type);
    }
    // 模板修改时间范围-起
    String modifyStart = (String) conditions.get(MESS_MODIFY_START);
    if (StringUtils.isNotBlank(modifyStart)) {
      condition.append(" AND  DATE_FORMAT ( te.modifyTime, '%Y-%m-%d' ) >= :modifyStart ");
      parameter.put(MESS_MODIFY_START, modifyStart);
    }
    // 模板修改时间范围-止
    String modifyEnd = (String) conditions.get(MESS_MODIFY_END);
    if (StringUtils.isNotBlank(modifyEnd)) {
      condition.append(" AND DATE_FORMAT ( te.modifyTime, '%Y-%m-%d' ) <= :modifyEnd ");
      parameter.put(MESS_MODIFY_END, modifyEnd);
    }
    // 模板创建时间范围-起
    Object createStart = conditions.get(MESS_CREATE_START);
    if (createStart != null) {
      condition.append(" AND te.createTime >= :createStart ");
      parameter.put(MESS_CREATE_START, createStart);
    }
    // 模板创建时间范围-止
    Object createEnd = conditions.get(MESS_CREATE_END);
    if (createEnd != null) {
      condition.append(" AND te.createTime <= :createEnd ");
      parameter.put(MESS_CREATE_END, createEnd);
    }
    // 表单名name
    String name = (String) conditions.get(MESS_NAME);
    if(StringUtils.isNotBlank(name)) {
      condition.append(" AND te.name like CONCAT('%',:name,'%') ");
      parameter.put(MESS_NAME, name);
    }
    // 项目名projectName
    String projectName = (String) conditions.get(MESS_PROJECT_NAME);
    if(StringUtils.isNotBlank(projectName)) {
      condition.append(" AND te.projectName = :projectName ");
      parameter.put(MESS_PROJECT_NAME, projectName);
    } else {
      condition.append(" AND (te.projectName = '' or te.projectName is null)");
    }
    hql.append(condition).append(" ORDER BY te.createTime desc ");
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
  }

  @SuppressWarnings("unchecked")
  @Override
  public List<TemplateEntity> findAllByConditions(TemplateEntity condition) {
    StringBuilder hql = new StringBuilder("select t from TemplateEntity t left join fetch t.maintainers tm where 1=1 ");
    StringBuilder conditions = new StringBuilder();
    Map<String, Object> parameters = new HashMap<>();
    //筛选项目
    conditions.append(" and t.projectName =:projectName");
    parameters.put("projectName", ApplicationContextUtils.getProjectName());
    if(condition != null) {
      if(condition.getTstatus() != null) {
        conditions.append(" and t.tstatus = :tstatus ");
        parameters.put("tstatus", condition.getTstatus());
      }
      if(StringUtils.isNotBlank(condition.getProjectName())) {
        conditions.append(" AND te.projectName = :projectName ");
        parameters.put(MESS_PROJECT_NAME, condition.getProjectName());
      } else {
        conditions.append(" AND (te.projectName = '' or te.projectName is null)");
      }
    }

    hql.append(conditions).append(" order by t.createTime desc");
    Query query = entityManager.createQuery(hql.toString());
    parameters.forEach((k, v) -> {
      query.setParameter(k, v);
    });
    return query.getResultList();
  }

}

