package com.bizunited.platform.kuiper.starter.service;

import com.bizunited.platform.kuiper.entity.FormDetailsImportBoxDetailsEntity;
import com.bizunited.platform.kuiper.entity.FormDetailsImportBoxEntity;
import com.bizunited.platform.kuiper.starter.vo.FormDetailsImportBoxVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.Map;
import java.util.Set;


/**
 * 基于表单引擎，列表引擎，对业务数据通过xls/xlsx文件的工具箱方式导入的相关操作
 *
 * @author Keller
 * @create 2020/8/23
 */
public interface FormDetailsImportBoxService {

  /**
   * 执行excel导入
   *
   * @param formDetailsImportBoxVo 导入参数vo
   * @param params                 扩展参数
   * @return 导入记录信息
   */
  FormDetailsImportBoxEntity execute(FormDetailsImportBoxVo formDetailsImportBoxVo, Map<String, Object> params);

  /**
   * 查询所有导入记录信息（分页）
   *
   * @param pageable
   * @return
   */
  Page<FormDetailsImportBoxEntity> queryPage(Pageable pageable);

  /**
   * 查询导入记录信息（单条）
   *
   * @param id
   * @return
   */
  FormDetailsImportBoxEntity findById(String id);

  /**
   * 按照主键进行信息的逻辑删除
   *
   * @param id 主键
   */
  void deleteById(String id);

  /**
   * 清除所有导入记录数据逻辑删除
   */
  void deleteAll();

  /**
   * 按照主键进行导入信息进程的取消
   *
   * @param id 主键
   */
  void cancel(String id);

  /**
   * 查询导入详情信息
   *
   * @param id
   */
  Page<FormDetailsImportBoxDetailsEntity> queryPageById(String id);

  /**
   * 导出错误数据文件
   *
   * @param id
   * @return
   */
  byte[] exportErrorFile(String id);


  /**
   * 获取所有处理类名称
   *
   * @return
   */
  Set<String> findProcessClassNames();
}
