package com.bizunited.platform.kuiper.starter.service;

import java.util.List;
import java.util.Set;

import com.bizunited.platform.kuiper.entity.InstanceActivityEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;

/**
 * 表单实例活动相关服务
 * @author yinwenjie
 */
public interface InstanceActivityService {
  /**
   * 在指定的表单实例下创建一个新的活动信息，
   * @param instance 指定的实例基本信息——主要要有其中关联的模板数据层编号信息
   */
  public InstanceActivityEntity create(InstanceActivityEntity activity, String account);
  /**
   * @param taskCode 指定的外部业务编号（可能在本系统存在也可能不在本系统存在）
   * @param instanceId 当前活动对应的实例编号
   * @param visibilityName 指定的可见性名称（在instanceId对应的模板中visibilityName是唯一的）
   * @param principal 当前的操作者
   * @return 返回可能存在也可能是依据instanceId、visibilityName新建的活动编号
   */
  public InstanceActivityEntity create(String taskCode , String instanceId , String visibilityName, String account);
  /**
   * 更新当前指定活动的最后修改人
   * @param activityId 指定的活动编号
   * @param account 新的操作者信息
   * @return
   */
  public InstanceActivityEntity updateModifyer(String activityId , String account);
  /**
   * 更新活动的模版
   * @param activities
   * @param template
   */
  public void updateTemplate(List<InstanceActivityEntity> activities, TemplateEntity template);
  /**
   * 按照活动编号，查询指定的活动信息详情——包括关联信息
   * @param id 指定的活动编号信息
   */
  public InstanceActivityEntity findDetailsById(String id);
  /**
   * 按照指定的表单实例编号，查询其下已经发生的活动(包括每一条活动的明细情况)，并按照活动创建实例反序排列
   * @param instanceId 指定的表单实例编号
   * @return 
   */
  public Set<InstanceActivityEntity> findDetailsByInstanceId(String instanceId);
  /**
   * 按照指定的表单实例编号，查询其下已经发生的活动(不包括活动的明细情况)，并按照活动创建实例反序排列
   * @param instanceId 指定的表单实例编号
   * @return 
   */
  public Set<InstanceActivityEntity> findByInstanceId(String instanceId);
  /**
   * 根据活动id，查询活动信息
   * @param id
   * @return
   */
  public InstanceActivityEntity findById(String id);
  /**
   * 根据外部业务编号，查询指定的实例活动信息（不包括关联信息）
   * @param taskCode 指定的外部业务编号
   * @return
   */
  public InstanceActivityEntity findByTaskCode(String taskCode);
  /**
   * 根据实例ID和任务code查询
   * @param instanceId
   * @param taskCode
   * @return
   */
  public InstanceActivityEntity findByInstanceIdAndTaskCode(String instanceId, String taskCode);
  
  /**
   * 按照指定的表单实例编号，查询这个表单实例下创建时间最新的那条活动信息id
   * @param instanceId 指定的表单实例编号
   */
  public String findIdByMaxCreateTime(String instanceId);
  /**
   * 根据实例ID和可见性查询
   * @param instanceId
   * @param visibility
   * @return
   */
  public Set<InstanceActivityEntity> findByInstanceIdAndVisibility(String instanceId, String visibility);
}