package com.bizunited.platform.kuiper.starter.service;

import com.bizunited.platform.kuiper.entity.PageEntity;
import com.bizunited.platform.kuiper.entity.PageEventEntity;

import java.util.Set;

/**
 * 页面事件服务接口定义
 * @Author: Paul Chan
 * @Date: 2019-12-31 16:43
 */
public interface PageEventService {

  /**
   * 保存页面事件的内容，通过事件ID做为唯一值进行比较来新增、修改、删除
   * @param page
   * @param pageEvent
   * @return
   */
  Set<PageEventEntity> save(PageEntity page, Set<PageEventEntity> events);

  /**
   * 根据pageId查询
   * @param pageId
   * @return
   */
  Set<PageEventEntity> findByPageId(String pageId);

  /**
   * 根据pageId查询详情
   * @param pageId
   * @return
   */
  Set<PageEventEntity> findDetailsByPageId(String pageId);

  /**
   * 根据ID查询详情
   * @param id
   * @return
   */
  PageEventEntity findDetailById(String id);

  /**
   * 根据页面编码和事件ID查询
   *
   * @param pageFlowCode
   * @param pageCode
   * @param eventId
   * @return
   */
  PageEventEntity findDetailByPageFlowCodeAndPageCodeAndEventId(String pageFlowCode, String pageCode, String eventId);

  /**
   * 根据页面ID删除事件
   * @param pageId
   */
  void deleteByPageId(String pageId);
}
