package com.bizunited.platform.kuiper.starter.service;

import com.bizunited.platform.common.model.MigrateImportModel;
import com.bizunited.platform.kuiper.entity.PageFlowEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.security.Principal;
import java.util.List;

/**
 * 页面流的服务接口定义
 * @Author: TanBoQiuYun
 * @Date: 2019/12/31 15:31
 */
public interface PageFlowService {

  /**
   * 创建页面流
   * @param pageFlow
   * @param principal
   * @return
   */
  PageFlowEntity create(PageFlowEntity pageFlow, Principal principal);

  /**
   * 更新页面流
   * @param pageFlow
   * @param principal
   * @return
   */
  PageFlowEntity update(PageFlowEntity pageFlow, Principal principal);

  /**
   * 根据页面流ID查询模版明细,包括关联信息
   * @param id
   * @return
   */
  PageFlowEntity findDetailsById(String id);

  /**
   * 根据ID查询页面流信息（注意只有基本信息，不包括任何的关联信息）
   * @param id
   * @return
   */
  PageFlowEntity findById(String id);

  /**
   * 根据编码查询页面流信息（注意只有基本信息，不包括任何的关联信息）
   * @param code
   * @return
   */
  PageFlowEntity findByCode(String code);

  /**
   * 按照数页面流编码进行查询明细查询，查询的明细包含页面流下的所有关联信息
   * @param code
   * @return
   */
  PageFlowEntity findDetailsByCode(String code);

  /**
   * 分页查询
   * @param pageFlow
   * @param pageable
   * @return
   */
  Page<PageFlowEntity> findByConditions(PageFlowEntity pageFlow, Pageable pageable);


  /**
   * 根据主键删除页面流以及所有关联信息
   * @param id
   */
  void deleteById(String id);

  /**
   * 查询所有页面流数据
   * @return
   */
  List<PageFlowEntity> findAll();

  /**
   * 根据ID集合统计数据
   * @param ids
   * @return
   */
  long countByIds(String[] ids);

  /**
   * 根据ID集合查询
   * @param ids
   * @return
   */
  List<PageFlowEntity> findDetailsByIds(String[] ids);

  /**
   * 导入页面流数据
   * @param importModel
   */
  void importData(MigrateImportModel importModel);
}
