package com.bizunited.platform.kuiper.starter.service;

import com.bizunited.platform.kuiper.entity.TemplateEventEntity;

import java.util.List;
import java.util.Set;

public interface TemplateEventService {
  /**
   * 操作保存模板事件
   * @param event
   * @return
   */
  void save(String templateId, List<TemplateEventEntity> eventEntityVo);
  /**
   * 该服务不需要公布到controller层，只限于在进行表单模板升级时，负责事件信息的升级操作
   * @param templateId
   * @param templateEvents 参照的一个或者多个事件信息
   * @return 
   */
  public Set<TemplateEventEntity> upgrade(String templateId , List<TemplateEventEntity> templateEvents);
  /**
   * 按照模板数据编号，删除指定的模板事件信息
   * @param templateId 指定的模板编号信息
   */
  public void deleteByTemplateId(String templateId);
  /**
   * 根据指定模板的id,查询已有的模板事件信息(不带fetch)
   * @param templateId
   * @return
   */
  List<TemplateEventEntity> findByTemplateId(String templateId);
  /**
   * 根据指定事件的id,查询事件信息
   * @param id
   * @return
   */
  TemplateEventEntity findDetailById(String id);

  /**
   * 根据指定模板id,查询所有事件详情信息
   * @param templateId
   * @return
   */
  Set<TemplateEventEntity> findDetailsByTemplateId(String templateId);
}
