package com.bizunited.platform.kuiper.starter.service;

import com.bizunited.platform.common.model.MigrateImportModel;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemExcelEntity;

import java.util.List;

/**
 * TemplateItemExcelService
 *
 * @description: 模板明细项上传EXCEL关联信息，用于保存，查询明细模板与上传EXCEL的关联关系
 * @author: yanwe
 * @date: 19/Aug/2019 17:02
 */

public interface TemplateItemExcelService {

  /**
   * 新增
   * @param templateItemExcelEntity
   * @return
   */
  TemplateItemExcelEntity save(TemplateItemExcelEntity templateItemExcelEntity);

  /**
   * 根据模板ID下查询所有模板明细关联EXCEL信息
   * @param templateId
   * @return
   */
  List<TemplateItemExcelEntity> findByTemplate(String templateId);
  /**
   * 根据分组模板ID查询所有模板明细关联EXCEL信息
   * @param templateGroupId
   * @return
   */
  List<TemplateItemExcelEntity> findByTemplateGroup(String templateGroupId);

  /**
   * 查询一个模板明细下唯一的EXCEL关联信息
   * @param templateItemId
   * @return
   */
  TemplateItemExcelEntity findByTemplateItem(String templateItemId);


  /**
   * 删除模板明细与EXCEL的关联信息，并且删除该EXCEL保存在本地目录
   * @param templateItemExcelEntityId
   */
  void delete(String templateItemExcelEntityId);

  /**
   * 导入表单模版明细项excel文件
   * @param template
   * @param templateItemExcels
   * @param importModel
   */
  void importData(TemplateEntity template, List<TemplateItemExcelEntity> templateItemExcels, MigrateImportModel importModel);
}
