package com.bizunited.platform.kuiper.starter.service;

import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateGroupEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemEntity;
import com.bizunited.platform.saturn.model.PersistentClass;
import com.bizunited.platform.saturn.model.PersistentRelation;

public interface TemplateItemService {  
  /**
   * 初始化静态模板中的“明细”信息，包括明细信息中的一般属性信息、和关联属性信息（关联属性信息只包括ManyToOne关系和ManyToMany关系）
   * @param parentTemplate 可能存在的上层主模板信息
   * @param parentGroup 可能存在的上层模板分组信息
   */
  public TemplateItemEntity initStaticItems(TemplateEntity parentTemplate , TemplateGroupEntity parentGroup , PersistentRelation parentRelation , PersistentClass persistentClass);
  
  /**
   * 初始化动态模板中的“明细”信息，包括明细信息中的一般属性、关联属性（关联属性信息只包括ManyToOne关系和ManyToMany关系）
   * @param parentTemplate
   * @param parentGroup
   * @param templateRelation
   * @return
   */
  public TemplateItemEntity initDynamicItems(TemplateItemEntity templateItem , TemplateEntity parentTemplate, TemplateGroupEntity parentGroup, String parentTableName);
  
  /**
   * 根据模版明细ID查询详情，包括该明细中的一般属性与关联属性
   * @param templateItemId
   * @return
   */
  TemplateItemEntity findDetailsById(String templateItemId);

  /**
   * 根据ID查询表单明细模板，包括附近表单，与可能的父级分组表单
   * @param templateItemId
   * @return
   */
  TemplateItemEntity findParentById(String templateItemId);
}
