package com.bizunited.platform.kuiper.starter.service;

import com.bizunited.platform.kuiper.entity.TemplateMaintainerEntity;

import java.security.Principal;
import java.util.Set;

public interface TemplateMaintainerService {
  /**
   * 具有授权权限的人，授权用户能维护其他用户创建的模板
   * @param templateId 指定模板id
   * @param maintainerIds 指定的可操作指定模板的维护人员id(数组)
   * @param maintainerAccounts 配置文件中的具有授权权限的人员账号信息
   * @param principal 当前用户
   */
  void binding(String templateId, String[] maintainerIds , String[] maintainerAccounts, Principal principal);

  /**
   * 根据模版ID查询详情信息
   * @return
   * @param templateId
   */
  Set<TemplateMaintainerEntity> findDetailsByTemplateId(String templateId);

  /**
   * 根据模版ID查询
   * @param templateId
   * @return
   */
  Set<TemplateMaintainerEntity> findByTemplateId(String templateId);

  /**
   * 授权用户能维护其他用户创建的模板
   * @param templateId
   * @param accounts
   */
  void binding(String templateId, String[] accounts);
}
