package com.bizunited.platform.kuiper.starter.service;

import java.util.List;




import com.bizunited.platform.kuiper.entity.TemplateStyleEntity;

public interface TemplateStyleService {
  /**
   * 查询目前系统中所有定义的样式信息，无论样式信息处于什么状态。并按照创建时间进行倒序排列
   * */
  public List<TemplateStyleEntity> findAll();
  /**
   * 按照指定的状态条件，查询符合状态的样式信息
   * @param tstatus 1：状态正确；0：状态异常
   * @return
   */
  public List<TemplateStyleEntity> findByTstatus(Integer tstatus);
  /**
   * 查询目前系统中，指定样式数据编号的样式基本信息
   * @param id 指定的样式编号信息
   */
  public TemplateStyleEntity findDetailsById(String id);
  /**
   * 查询目前系统中，指定样式业务编号（code）的样式基本信息
   * @param id 指定的样式编号信息
   */
  public TemplateStyleEntity findDetailsByCode(String code);
  /**
   * 按照指定的表单样式业务编号（code），查询指定的样式文件内容信息
   * @return 指定的文件内容，如果没有查询到任何文件内容，则返回一个空数组
   */
  public byte[] findContentByCode(String code);
  /**
   * 创建一个模板样式信息
   * @param templateStyle 样式基本信息
   * @param fileContent 文件内容
   * @param systemStyle 当前新增的样式是否是系统样式（系统样式不允许修改）
   * @param prefix 文件后缀
   * @return
   */
  public TemplateStyleEntity create(TemplateStyleEntity templateStyle , byte[] fileContent , boolean systemStyle , String prefix);
  /**
   * 修改指定的模板样式信息，注意：只有一部分信息可以修改（只有样式中文说明，文件内容信息）
   * @param templateStyle 指定的模板样式对象
   * @param fileContent 指定的文件内容信息
   * @param prefix 文件后缀
   * @return 
   */
  public TemplateStyleEntity update(TemplateStyleEntity templateStyle , byte[] fileContent , String prefix);
  /**
   * 按照指定的样式数据层编号，对指定样式信息的状态进行修改
   * @param id 指定的数据层编号
   */
  public void updateStatusById(String id , boolean tstatus);
}