package com.bizunited.platform.kuiper.starter.service.init;

import com.bizunited.platform.common.service.init.InitProcessService;
import com.bizunited.platform.kuiper.starter.service.FrontFileSevice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.transaction.Transactional;

/**
 * 该初始化过程用于完成表单引擎前段函数的初始化动作
 * @author yinwenjie
 */
@Component("FrontFileInitProcess")
public class FrontFileInitProcess implements InitProcessService {
  @Autowired
  private FrontFileSevice frontFileSevice;
  // 脚本1的名字
  private static final String SCRIPT_ONE = "submitValidateBefore()";
  // 脚本2的名字
  private static final String SCRIPT_TWO = "submitBefore()";
  
  @Override
  public boolean doProcess() {
    // 如果缺少两个脚本中的任意一个，都要进行初始户撒
    return frontFileSevice.findByName(SCRIPT_ONE) == null || frontFileSevice.findByName(SCRIPT_TWO) == null;
  }

  @Override
  @Transactional
  public void init() {
    if(frontFileSevice.findByName(SCRIPT_ONE) == null) {
      this.initFrontFileOne();
    }
    if(frontFileSevice.findByName(SCRIPT_TWO) == null) {
      this.initFrontFileTwo();
    }
  }
  
  /**
   * 初始化第一个脚本
   */
  private void initFrontFileOne() {
    // 脚本1
    String frontFileEntityStr = "{\"name\":\"" + SCRIPT_ONE + "\",\"fileDesc\":\"提交之前验证\"}";
    String fileContent = "next()";
    frontFileSevice.create(frontFileEntityStr,fileContent);
  }
  
  /**
   * 初始化第二个脚本
   */
  private void initFrontFileTwo() {
    String frontFileEntityStr = "{\"name\":\"" + SCRIPT_TWO + "\",\"fileDesc\":\"提交之前\"}";
    String fileContent = "next()";
    frontFileSevice.create(frontFileEntityStr,fileContent);
  }
}
