package com.bizunited.platform.kuiper.starter.service.instances.handle;

import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

import com.bizunited.platform.kuiper.entity.InstanceActivityEntity;
import com.bizunited.platform.kuiper.entity.InstanceEntity;
import com.bizunited.platform.kuiper.starter.service.InstanceActivityService;

/**
 * 这是一个抽象的父类，为DynamicFormDetailsRequestHandle、DynamicFormDetailsResponseHandle两个handle处理器，描述公共的处理逻辑
 * @author yinwenjie
 *
 */
public abstract class AbstractDynamicFormDetailsHandle {
  
  /**
   * 活动实例服务
   */
  @Autowired
  private InstanceActivityService instanceActivityService;
  
  /**
   * 根据活动id，查询对应的动态实例id
   * @param instanceActivityId
   * @return
   */
  protected String findInstanceIdByInstanceActivityId(String instanceActivityId) {
    Validate.notBlank(instanceActivityId , "活动实例编号不能为null");
    InstanceActivityEntity currentInstanceActivity = instanceActivityService.findById(instanceActivityId);
    Validate.notNull(currentInstanceActivity , "未通过活动实例ID查找到指定的活动实例对象信息，请检查!!");
    InstanceEntity instanceEntity = currentInstanceActivity.getInstance();
    Validate.notNull(instanceEntity , "未找到指定的表单实例信息，请检查!!");
    String instanceId = instanceEntity.getId();
    return instanceId;
  }
}
