package com.bizunited.platform.kuiper.starter.service.instances.handle;

import com.alibaba.fastjson.JSON;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.HandleChain.ChainLogic;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.core.service.serviceable.model.ServicableMethodInfo;
import com.bizunited.platform.kuiper.entity.InstanceActivityEntity;
import com.bizunited.platform.kuiper.starter.service.InstanceActivityService;
import com.bizunited.platform.kuiper.starter.service.KuiperToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * 该处理器用于在WRITE性质的服务方法之前，调用查询静态表单详情的方法
 * 然后将查询出来的数据，以json的形式放于上下文中，便于表单日志功能做数据对比
 */
public class StaticFormDetailsRequestHandle implements InvokeRequestHandle {

  private static final Logger LOGGER = LoggerFactory.getLogger(StaticFormDetailsRequestHandle.class);
  /**
   * 用于存储前置处理得到的查询结果值的key
   */
  private static final String BEFORE_DETAILS = "_beforeDetails";
  /**
   * 柯伊伯表单引擎服务工具类
   */
  @Autowired
  @Qualifier("KuiperToolkitService")
  private KuiperToolkitService kuiperToolkitService;
  @Autowired
  private ServicableMethodService servicableMethodService;
  @Autowired
  private InstanceActivityService instanceActivityService;

  /* (non-Javadoc)
   * @see com.bizunited.platform.core.service.invoke.InvokeRequestHandle#doHandle(com.bizunited.platform.core.service.invoke.InvokeProxyContext, com.bizunited.platform.core.service.invoke.HandleChain)
   */
  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
    /*
     * 要基于静态表单，进行某个写性质的服务源操作前的数据记录工作，需要传入以下参数信息
     * a、instanceId、taskcode、instanceActivityId三个参数任选其一（处理器将优先使用instanceId为标准）
     * b、detailsServiceName，用于描述查询指定数据的服务源，这个服务源必须有一个字符串的入参，可以绑定以上三个参数中的一个，例如：
     * 
     * @NebulaServiceMethod(name="StudentService.findByStudentDetails" , desc = "这是一个数据的详情查询服务源")
     * public StudentEntity findByStudentDetails(@ServiceMethodParam(name = "taskcode") String studentCode).....
     * 
     * 如果要使用以上的服务源进行写操作前信息的明细查询工作，则detailsServiceName需要传入taskcode
     * 
     * */
    
    InvokeParams invokeParams = context.getParams();
    String detailsServiceName = invokeParams.getInvokeParam("detailsServiceName") == null?"":invokeParams.getInvokeParam("detailsServiceName").toString();
    if(StringUtils.isBlank(detailsServiceName)) {
      this.doHandle(context, chain);
      return;
    }
    ServicableMethodInfo methodInfo = servicableMethodService.findDetailsByName(detailsServiceName);
    Validate.notNull(methodInfo , "未找到指定的服务方法信息[%s]，请检查!!" , detailsServiceName);
    
    // 确认查询数据详情的依据，如果没有任何依据，也不会执行数据记录
    Object instanceIdValue = invokeParams.getInvokeParam("instanceId");
    Object taskcodeValue = invokeParams.getInvokeParam("taskcode");
    Object instanceActivityIdValue = invokeParams.getInvokeParam("instanceActivityId");
    if((instanceIdValue == null || StringUtils.isBlank(instanceIdValue.toString()))
        && (taskcodeValue == null || StringUtils.isBlank(taskcodeValue.toString()))
        && (instanceActivityIdValue == null || StringUtils.isBlank(instanceActivityIdValue.toString()))) {
      this.doHandle(context, chain);
      return;
    }
    
    //获取当前操作传入的表单数据
    String instanceActivityId = null;
    String instanceId = null;
    InvokeParams newInvokeParams = new InvokeParams();
    if(instanceActivityIdValue != null && StringUtils.isNotBlank(instanceActivityIdValue.toString())) {
      instanceActivityId = instanceActivityIdValue.toString();
      InstanceActivityEntity instanceActivity = this.instanceActivityService.findById(instanceActivityId);
      Validate.notNull(instanceActivity , "根据指定的实例活动，未找到对应的信息，请检查!!");
      instanceId = instanceActivity.getInstance().getId();
    } else if(taskcodeValue != null && StringUtils.isNoneBlank(taskcodeValue.toString())) {
      String taskcode = taskcodeValue.toString();
      InstanceActivityEntity instanceActivity = this.instanceActivityService.findByTaskCode(taskcode);
      Validate.notNull(instanceActivity , "根据指定的实例活动，未找到对应的信息，请检查!!");
      instanceActivityId = instanceActivity.getId();
      instanceId = instanceActivity.getInstance().getId();
    } else {
      instanceId = instanceIdValue.toString(); 
      instanceActivityId = this.instanceActivityService.findIdByMaxCreateTime(instanceId);
      Validate.notBlank(instanceActivityId , "根据指定的实例活动[%s]，未找到对应的信息，请检查!!" , instanceId);
    }
    invokeParams.putInvokeParam("instanceId", instanceId);
    invokeParams.putInvokeParam("instanceActivityId", instanceActivityId);
    
    // 从指定的查询服务源获取数据更改前的明细信息
    newInvokeParams.putInvokeParam("instanceId", instanceId);
    newInvokeParams.putInvokeParam("instanceActivityId", instanceActivityId);
    newInvokeParams.putInvokeParam("taskcodeValue", taskcodeValue);
    Object result = this.servicableMethodService.invoke(detailsServiceName, newInvokeParams);
    Object jsonResult = JSON.toJSON(result);
    LOGGER.debug("前置数据：{}", result);
    invokeParams.putInvokeParam(BEFORE_DETAILS, jsonResult);
    
    // 继续下一个处理节点
    chain.doHandle(context, ChainLogic.CONTINUE);
  }
}
