package com.bizunited.platform.kuiper.starter.service.internal;

import java.util.Set;

import javax.transaction.Transactional;

import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.kuiper.entity.TemplateOprtLogEntity;
import com.bizunited.platform.kuiper.starter.repository.TemplateOprtLogRepository;
import com.bizunited.platform.kuiper.starter.service.TemplateOprtLogService;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("TemplateOprtLogServiceImpl")
public class TemplateOprtLogServiceImpl implements TemplateOprtLogService {
  
  @Autowired
  private TemplateOprtLogRepository templateOprtLogRepository;

  @Override
  public Set<TemplateOprtLogEntity> findByTemplateId(String templateId) {
    if(StringUtils.isBlank(templateId)) {
      return Sets.newHashSet();
    }
    return templateOprtLogRepository.findByTemplateId(templateId);
  }

  @Override
  @Transactional
  public TemplateOprtLogEntity create(TemplateOprtLogEntity log) {
    Validate.notNull(log, "模板变更日志信息不能为空，请检查!!");
    Validate.isTrue(StringUtils.isBlank(log.getId()), "模板变更日志id信息不能有值，请检查!!");
    log.setId(null);
    log.setProjectName(ApplicationContextUtils.getProjectName());
    return templateOprtLogRepository.save(log);
  }

}
