package com.bizunited.platform.mars.repository.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.persistence.EntityManager;
import javax.persistence.Query;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.mars.entity.RuleTemplateNodeEntity;

@Repository("RuleTemplateNodeEntityRepositoryImpl")
public class RuleTemplateNodeEntityRepositoryImpl implements RuleTemplateNodeEntityRepositoryCustom , PageRepositoryImpl {
  @Autowired
  private EntityManager entityManager; 
  
  @SuppressWarnings("unchecked")
  @Override
  public List<RuleTemplateNodeEntity> findByTemplateGroupAndStatusAndType(String templateGroup, Integer nodeStatus, Integer type) {
    StringBuilder hql = new StringBuilder("from RuleTemplateNodeEntity et left join fetch et.templateGroup tg where 1=1");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameters = new HashMap<>();

    // 分组信息
    if(StringUtils.isNotBlank(templateGroup)) {
      condition.append(" AND tg.id = :templateGroup ");
      parameters.put("templateGroup", templateGroup);
    }
    // 节点状态
    if(nodeStatus != null) {
      condition.append(" AND et.nodeStatus = :nodeStatus ");
      parameters.put("nodeStatus", nodeStatus);
    }
    // 节点类型
    if(type != null) {
      condition.append(" AND et.type = :type ");
      parameters.put("type", type);
    }
    
    hql.append(condition).append(" order by et.createTime desc  ");
    Query query = entityManager.createQuery(hql.toString());
    parameters.forEach((k, v) -> {
      query.setParameter(k, v);
    });
    return query.getResultList();
  }
}
