package com.bizunited.platform.mars.service;

import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.annotations.NebulaServiceMethod.ScopeType;
import com.bizunited.platform.core.annotations.ServiceMethodParam;
import com.bizunited.platform.mars.entity.RuleTemplateNodeEntity;
import java.lang.String;
import java.util.List;
import java.util.Set;

/**
 * RuleTemplateNodeEntity业务模型的服务层接口定义
 * @author saturn
 */
public interface RuleTemplateNodeEntityService { 
  /**
   * 创建一个新的RuleTemplateNodeEntity模型对象（包括了可能的第三方系统调用、复杂逻辑处理等）
   */
  @NebulaServiceMethod(name="RuleTemplateNodeEntityService.create" , desc="创建一个新的RuleTemplateNodeEntity模型对象（包括了可能的第三方系统调用、复杂逻辑处理等）" , returnPropertiesFilter="" , scope=ScopeType.WRITE)
  public RuleTemplateNodeEntity create(RuleTemplateNodeEntity ruleTemplateNodeEntity);
  /**
   * 创建一个新的StudentEntity模型对象
   * 该代码由satrun骨架生成，默认不包括任何可能第三方系统调用、任何复杂逻辑处理等，主要应用场景为前端表单数据的暂存功能</br>
   * 该方法与本接口中的updateFrom方法呼应
   */
  @NebulaServiceMethod(name="RuleTemplateNodeEntityService.createForm" , desc="创建一个新的StudentEntity模型对象（默认不包括任何可能第三方系统调用、任何复杂逻辑处理等）" , returnPropertiesFilter="" , scope=ScopeType.WRITE)
  public RuleTemplateNodeEntity createForm(RuleTemplateNodeEntity ruleTemplateNodeEntity);
  /**
   * 更新一个已有的RuleTemplateNodeEntity模型对象，其主键属性必须有值(1.1.4-release版本调整)。
   * 这个方法实际上一共分为三个步骤（默认）：</br>
   * 1、调用updateValidation方法完成表单数据更新前的验证</br>
   * 2、调用updateForm方法完成表单数据的更新</br>
   * 3、完成开发人员自行在本update方法中书写的，进行第三方系统调用（或特殊处理过程）的执行。</br>
   * 这样做的目的，实际上是为了保证updateForm方法中纯粹是处理表单数据的，在数据恢复表单引擎默认调用updateForm方法时，不会影响任何第三方业务数据
   * （当然，如果系统有特别要求，可由开发人员自行完成代码逻辑调整）
   */
  @NebulaServiceMethod(name="RuleTemplateNodeEntityService.update" , desc="更新一个已有的RuleTemplateNodeEntity模型对象，其主键属性必须有值(1.1.4-release版本调整)。" , returnPropertiesFilter="", scope=ScopeType.WRITE)
  public RuleTemplateNodeEntity update(RuleTemplateNodeEntity ruleTemplateNodeEntity);
  /**
   * 该方法只用于处理业务表单信息，包括了主业务模型、其下的关联模型、分组信息和明细细信息等
   * 该方法非常重要，因为如果进行静态表单的数据恢复，那么表单引擎将默认调用主业务模型（服务层）的这个方法。</br>
   * 这样一来保证了数据恢复时，不会涉及任何第三方系统的调用（当然，如果开发人员需要涉及的，可以自行进行修改）
   */
  @NebulaServiceMethod(name="RuleTemplateNodeEntityService.updateForm" , desc="该方法只用于处理业务表单信息，包括了主业务模型、其下的关联模型、分组信息和明细细信息等" , returnPropertiesFilter="", scope=ScopeType.WRITE)
  public RuleTemplateNodeEntity updateForm(RuleTemplateNodeEntity ruleTemplateNodeEntity);
  /**
   *  按照主键进行信息的真删除 
   * @param id 主键 
   */
  public void deleteById(String id);
  /**
   * 基于指定的模板分组ID，绑定模板节点信息（支持多个，增量绑定）
   * @param id
   * @param templateNodeIds
   */
  public void bindTemplateGroup(String templateGroupId , String[] templateNodeIds);
  /**
   * 基于指定的模板分组ID，重绑定模板节点信息（重绑定）
   * @param id
   * @param templateNodeIds
   */
  public void rebindTemplateGroup(String templateGroupId , String[] templateNodeIds);
  /**
   * 基于指定的模板分组，解除绑定模板节点信息
   * @param id
   * @param templateNodeIds
   */
  public void unbindTemplateGroups(String templateGroupId , String[] templateNodeIds);
  /**
   * 基于指定的模板分组，解除所有节点模板和他的绑定关系
   * @param id
   * @param templateNodeIds
   */
  public void unbindAllTemplateGroups(String templateGroupId);
  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   */
  @NebulaServiceMethod(name="RuleTemplateNodeEntityService.findDetailsById" , desc="按照主键进行详情查询（包括关联信息）" , returnPropertiesFilter="" , scope=ScopeType.READ)
  public RuleTemplateNodeEntity findDetailsById(@ServiceMethodParam(name="id") String id);
  /**
   * 按照RuleTemplateNodeEntity的主键编号，查询指定的数据信息（不包括任何关联信息）
   * @param id 主键
   * */
  public RuleTemplateNodeEntity findById(String id);
  /**
   * 按照节点模板业务编号进行查询
   * @param code 节点模板业务编号
   */
  @NebulaServiceMethod(name="RuleTemplateNodeEntityService.findByCode" , desc="按照节点模板业务编号进行查询" , returnPropertiesFilter="", scope=ScopeType.READ)
  public RuleTemplateNodeEntity findByCode(@ServiceMethodParam(name="code") String code);
  /**
   * 按照节点定义编号进行详细信息查询（包括了该节点模板关联的出参、入参，处理器信息）
   * @param code 指定的模板节点业务编号
   * @return
   */
  public RuleTemplateNodeEntity findDetailsByCode(String code);
  /**
   * 按照模板节点分组，查询属于这个模板分组下符合模板定义的模板节点的信息（只包括基本信息）,返回信息将按照节点模板业务编号进行排序
   * @param templateGroup 指定的模板分组id
   * @param nodeStatus 节点模板的状态条件(可以不传入)，如果不传就不再参考该条件
   * @return
   */
  public Set<RuleTemplateNodeEntity> findByTemplateGroupAndStatus(String templateGroup , Integer nodeStatus);
  /**
   * 按照模板节点分组，节点状态，节点模板类型查询符合要求的模板节点的信息（只包括基本信息）,返回信息将按照创建时间进行倒叙排列</br>
   * 注意，其中的三个参数都不是必须填写的
   * @param templateGroup 指定的模板分组id
   * @param nodeStatus 节点模板的状态条件(可以不传入)，如果不传就不再参考该条件
   * @param type  1:判定组件、2、逻辑组件、3、锁组件，4、开始组件、5、结束组件、
   * @return
   */
  public List<RuleTemplateNodeEntity> findByTemplateGroupAndStatusAndType(String templateGroup , Integer nodeStatus , Integer type);
  /**
   * 按照模板节点分组，查询属于这个模板分组下模板节点的信息（只包括基本信息）,返回数量信息
   * @param templateGroup 指定的模板分组id
   * @return 
   */
  public long countByTemplateGroup(String templateGroup);
}