package com.bizunited.platform.mars.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 规则定义节点的连接线，以及连接线条件。</br>
 * 除非当前节点是条件判定节点，否则连接后续节点的连线只可能有一条正确类型（且不能带条件表达式）
 * @Author yinwenjie
 * @Date  2020-06-20
 */
@Entity
@Table(name = "engine_rule_node_next" , indexes = {@Index(columnList = "from_node_id , to_node_id" ,unique = true )})
@ApiModel(value = "RuleNodeNextsEntity" , description="规则定义节点的连接线")
@org.hibernate.annotations.Table(appliesTo = "engine_rule_node_next" , comment = "规则定义节点的连接线")
public class RuleNodeNextsEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 3218912718719020074L;
  /**
   * 该连接线对应的节点信息（起始节点）
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="from_node_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '该连接线对应的节点信息（起始节点）'")
  @SaturnColumn(description="该连接线对应的开始信息（起始节点）")
  private RuleNodeEntity fromNode;
  /**
   * 该连接线对应的节点信息（目标节点）
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="to_node_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '该连接线对应的节点信息（目标节点）'")
  @SaturnColumn(description="该连接线对应的开始信息（目标节点）")
  private RuleNodeEntity toNode;
  /**
   * 如果当前处理节点有多个连续线
   * 则连接线的判定顺序以当前设定值为准（值越小优先级越高）
   */
  @ApiModelProperty(name = "sort", value = "连接线的判定顺序")
  @Column(name = "sort" , nullable = false , columnDefinition = "int(11)  COMMENT '连接线的判定顺序'")
  @SaturnColumn(description = "连接线的判定顺序")
  private Integer sort = 100;
  /**
   * 线条类型(1：正常线；2：异常线)
   */
  @ApiModelProperty(name = "lineType", value = "线条类型(1：正常线；2：异常线)")
  @Column(name = "line_type" , nullable = false , columnDefinition = "int(11)  COMMENT '线条类型(1：正常线；2：异常线)'")
  @SaturnColumn(description = "线条类型(1：正常线；2：异常线)")
  private Integer lineType;
  /**
   * 流转表达式（流转条件）
   */
  @ApiModelProperty(name = "conditions", value = "流转表达式（流转条件）" , required = false)
  @Column(name = "conditions", nullable = true , columnDefinition = "varchar(255) COMMENT '流转表达式（流转条件）'")
  @SaturnColumn(description = "流转表达式（流转条件）")
  private String conditions;
  /**
   * 异常线支持的完整异常类型（多个使用“,”分割）
   */
  @ApiModelProperty(name = "exceptions", value = "异常线支持的完整异常类型（多个使用“,”分割）" , required = false)
  @Column(name = "exceptions" , length = 255 , nullable = true , columnDefinition = "varchar(255) COMMENT '异常线支持的完整异常类型（多个使用“,”分割）'")
  @SaturnColumn(description = "异常线支持的完整异常类型")
  private String exceptions;
  
  public RuleNodeEntity getFromNode() {
    return fromNode;
  }
  public void setFromNode(RuleNodeEntity fromNode) {
    this.fromNode = fromNode;
  }
  public RuleNodeEntity getToNode() {
    return toNode;
  }
  public void setToNode(RuleNodeEntity toNode) {
    this.toNode = toNode;
  }
  public Integer getSort() {
    return sort;
  }
  public void setSort(Integer sort) {
    this.sort = sort;
  }
  public Integer getLineType() {
    return lineType;
  }
  public String getExceptions() {
    return exceptions;
  }
  public void setExceptions(String exceptions) {
    this.exceptions = exceptions;
  }
  public String getConditions() {
    return conditions;
  }
  public void setConditions(String conditions) {
    this.conditions = conditions;
  }
  public void setLineType(Integer lineType) {
    this.lineType = lineType;
  }
}